package com.ec.primus.commons.jackson.serialize;

import com.ec.primus.commons.exception.LongValueFormatException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;


public class StringifyAnnotationFieldJsonDeserializer
        extends JsonDeserializer<Long> {
    private String nullString = String.valueOf(null);

    @Override
    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        if ((StringUtils.isBlank(value)) || (this.nullString.equals(value))) {
            return null;
        }
        if (!StringUtils.isNumeric(value)) {
            throw new LongValueFormatException(String.format("解析 \"%s\":\"%s\" 出现异常,请检查数据是否正确", p
                    .getParsingContext().getCurrentName(), value));
        }
        try {
            return Long.valueOf(value);
        } catch (NumberFormatException e) {
            throw new LongValueFormatException(String.format("解析 \"%s\":\"%s\" 出现异常,请检查数据是否正确", p
                    .getParsingContext().getCurrentName(), value));
        }
    }
}
