package com.ec.primus.commons.utils;

import java.util.Collection;
import java.util.Map;

import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.exception.BusinessSilentException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;


public class AssertUtils {
    public static void isTrue(boolean expression, ExceptionType type)
            throws BusinessSilentException {
        if (!expression) {
            throw new BusinessSilentException(type);
        }
    }

    public static void isNull(Object object, ExceptionType type) throws BusinessSilentException {
        if (object != null) {
            throw new BusinessSilentException(type);
        }
    }

    public static void notNull(Object object, ExceptionType type) throws BusinessSilentException {
        if (object == null) {
            throw new BusinessSilentException(type);
        }
    }

    public static void hasLength(String text, ExceptionType type) throws BusinessSilentException {
        if (!StringUtils.hasLength(text)) {
            throw new BusinessSilentException(type);
        }
    }

    public static void hasText(String text, ExceptionType type) throws BusinessSilentException {
        if (!StringUtils.hasText(text)) {
            throw new BusinessSilentException(type);
        }
    }

    public static void hasText(String text, ExceptionType type, Object... args) throws BusinessSilentException {
        if (!StringUtils.hasText(text)) {
            throw new BusinessSilentException(type, args);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, ExceptionType type) throws BusinessSilentException {
        if ((StringUtils.hasLength(textToSearch)) && (StringUtils.hasLength(substring)) &&
                (textToSearch.contains(substring))) {
            throw new BusinessSilentException(type);
        }
    }

    public static void notEmpty(Object[] array, ExceptionType type) throws BusinessSilentException {
        if (ObjectUtils.isEmpty(array)) {
            throw new BusinessSilentException(type);
        }
    }

    public static void noNullElements(Object[] array, ExceptionType type) throws BusinessSilentException {
        if (array != null) {
            for (Object element : array) {
                if (element == null) {
                    throw new BusinessSilentException(type);
                }
            }
        }
    }

    public static void notEmpty(Collection<?> collection, ExceptionType type) throws BusinessSilentException {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessSilentException(type);
        }
    }

    public static void notEmpty(Map<?, ?> map, ExceptionType type) throws BusinessSilentException {
        if (CollectionUtils.isEmpty(map)) {
            throw new BusinessSilentException(type);
        }
    }

    public static void isTrue(boolean expression, ExceptionType type, String message) throws BusinessSilentException {
        if (!expression) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void isTrue(boolean expression, ExceptionType type, Object... args) throws BusinessSilentException {
        if (!expression) {
            throw new BusinessSilentException(type, args);
        }
    }

    public static void isNull(Object object, ExceptionType type, String message) throws BusinessSilentException {
        if (object != null) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void notNull(Object object, ExceptionType type, String message) throws BusinessSilentException {
        if (object == null) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void notNull(Object object, ExceptionType type, Object... args) throws BusinessSilentException {
        if (object == null) {
            throw new BusinessSilentException(type, args);
        }
    }

    public static void hasLength(String text, ExceptionType type, String message) throws BusinessSilentException {
        if (!StringUtils.hasLength(text)) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void hasText(String text, ExceptionType type, String message) throws BusinessSilentException {
        if (!StringUtils.hasText(text)) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, ExceptionType type, String message) throws BusinessSilentException {
        if ((StringUtils.hasLength(textToSearch)) && (StringUtils.hasLength(substring)) &&
                (textToSearch.contains(substring))) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void notEmpty(Object[] array, ExceptionType type, String message) throws BusinessSilentException {
        if (ObjectUtils.isEmpty(array)) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void noNullElements(Object[] array, ExceptionType type, String message) throws BusinessSilentException {
        if (array != null) {
            for (Object element : array) {
                if (element == null) {
                    throw new BusinessSilentException(type, message);
                }
            }
        }
    }

    public static void notEmpty(Collection<?> collection, ExceptionType type, String message) throws BusinessSilentException {
        if (CollectionUtils.isEmpty(collection)) {
            throw new BusinessSilentException(type, message);
        }
    }

    public static void notEmpty(Map<?, ?> map, ExceptionType type, String message) throws BusinessSilentException {
        if (CollectionUtils.isEmpty(map)) {
            throw new BusinessSilentException(type, message);
        }
    }
}