package com.ec.primus.commons.utils;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.exception.CommonExceptions;
import com.ec.primus.commons.lang.Alphabet;
import com.ec.primus.commons.utils.security.AesCryptographer;
import com.ec.primus.commons.utils.security.MD5Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Base64;


public class OpenIdUtils {
    private static final Logger log = LoggerFactory.getLogger(OpenIdUtils.class);


    public static String idToOpenId(Long id, String channel) {
        AssertUtils.notNull(id, CommonExceptions.PARAM_ERROR, "Argument id is null.");
        AssertUtils.notNull(channel, CommonExceptions.PARAM_ERROR, "Argument channel is null.");
        String channelPrefix = buildChannelPrefix(channel);
        String channelMd5 = MD5Utils.instance().digest(channel);
        String processedId = Long.toString(id, 36);
        byte[] encryptId = new AesCryptographer().cbcEncrypt(processedId, channelMd5.substring(0, 16), channelMd5.substring(16));
        return channelPrefix + Base64.getEncoder().encodeToString(encryptId).replaceAll("=", "");
    }


    public static Long openIdToId(String openId, String channel) {
        AssertUtils.notNull(openId, CommonExceptions.PARAM_ERROR, "Argument openId is null.");
        AssertUtils.notNull(channel, CommonExceptions.PARAM_ERROR, "Argument channel is null.");
        String channelPrefix = buildChannelPrefix(channel);
        if (openId.startsWith(channelPrefix)) {
            try {
                String channelMd5 = MD5Utils.instance().digest(channel);
                byte[] bytes = Base64.getDecoder().decode(openId.substring(channelPrefix.length()));
                String decryptOpenId = new String(new AesCryptographer().cbcDecrypt(bytes, channelMd5.substring(0, 16), channelMd5.substring(16)), "UTF-8");
                return Long.valueOf(decryptOpenId, 36);
            } catch (Throwable e) {
                if (log.isTraceEnabled()) {
                    log.trace("Decrypt openId failed.", e);
                }
            }
        }
        throw new BusinessSilentException("Invalid openId");
    }

    private static String buildChannelPrefix(String channel) {
        return Long.toString(Math.abs(Alphabet.toLongValue(channel)), 36);
    }
}