package com.ec.primus.commons.utils;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.google.common.collect.Maps;

import java.util.Map;

import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;


public class Stopwatch {
    private static final Logger log = LoggerFactory.getLogger(Stopwatch.class);


    private StopWatch sw = new StopWatch();

    private Map<String, Long> map = Maps.newLinkedHashMap();

    private long preTime = 0L;

    private boolean enabled = true;

    private Logger privateLogger = null;


    public static Stopwatch createAndBegin(boolean enabled) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.enabled = enabled;
        if (!enabled) {
            return stopwatch;
        }
        stopwatch.sw.start();
        return stopwatch;
    }


    public static Stopwatch createAndBegin(Logger logger) {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.privateLogger = logger;
        stopwatch.enabled = logger.isDebugEnabled();
        if (!stopwatch.enabled) {
            return stopwatch;
        }
        stopwatch.sw.start();

        return stopwatch;
    }


    public void start()
            throws BusinessSilentException {
        if (this.enabled) {
            throw new BusinessSilentException("Stopwatch already started.");
        }
        this.enabled = true;
        this.sw.start();
    }


    public void record(String tag) {
        if (!this.enabled) {
            return;
        }
        this.sw.split();
        long splitTime = this.sw.getSplitTime();
        long sub = splitTime - this.preTime;

        this.map.put(tag, sub);
        this.preTime = splitTime;
    }

    private Map<String, Long> out() {
        if ((!this.enabled) || (this.sw.isStopped())) {
            return this.map;
        }
        this.sw.stop();
        long all = this.sw.getTime();
        this.map.put("总计用时", all);
        return this.map;
    }


    public void print(String tag) {
        print(Level.DEBUG, tag);
    }


    public void print(Level logLevel, String tag) {
        if (!this.enabled) {
            return;
        }
        switch (logLevel) {
            case DEBUG:
                getLogger().debug(tag + " {}", out());
                break;
            case INFO:
                getLogger().info(tag + " {}", out());
                break;
            case WARN:
                getLogger().warn(tag + " {}", out());
                break;
            case ERROR:
                getLogger().error(tag + " {}", out());
                break;
            default:
                getLogger().trace(tag + " {}", out());
        }
    }

    private Logger getLogger() {
        return (Logger) ValueUtils.getValueOrDefault(this.privateLogger, log);
    }
}


/* Location:              D:\workStorage\项目资料\快喝\架构信息\wine\commons\1.1.0\commons-1.1.0.jar!\cn\wine\commo\\utils\Stopwatch.class
 * Java compiler version: 8 (52.0)
 * JD-Core Version:       0.7.1
 */