package com.ec.primus.commons.utils.geo;

import org.springframework.web.client.RestTemplate;


public class BaiduMapUtil {
    public static String getLocationDecode(BaiduMapConfig baiduMapConfig, Object latitude, Object longitude) {
        RestTemplate restTemplate = new RestTemplate();
        String requestUrl = String.format(baiduMapConfig.getLocationDecodeUrl(), latitude, longitude, baiduMapConfig
                .getBaiduMapAk());
        return (String) restTemplate.getForObject(requestUrl, String.class);
    }

    public static String getLocationEncode(BaiduMapConfig baiduMapConfig, String address) {
        RestTemplate restTemplate = new RestTemplate();
        String requestUrl = String.format(baiduMapConfig.getLocationEncodeUrl(), address, baiduMapConfig
                .getBaiduMapAk());
        return (String) restTemplate.getForObject(requestUrl, String.class);
    }
}