package com.ec.primus.commons.utils.security;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;

import org.apache.commons.codec.digest.DigestUtils;


public class MD5Utils
        implements IDigestUtils {
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST_THREAD_LOCAL = new ThreadLocal<>();

    private static MessageDigest getMessageDigest() {
        if (MESSAGE_DIGEST_THREAD_LOCAL.get() == null) {
            MESSAGE_DIGEST_THREAD_LOCAL.set(DigestUtils.getMd5Digest());
        }
        return (MessageDigest) MESSAGE_DIGEST_THREAD_LOCAL.get();
    }

    private static class Md5UtilsInstanceHolder {
        private static final MD5Utils INSTANCE = new MD5Utils();
    }

    public static MD5Utils instance() {
        return Md5UtilsInstanceHolder.INSTANCE;
    }

    @Override
    public String digest(File source)
            throws IOException {
        return DigestHelper.digest(getMessageDigest(), source);
    }


    @Override
    public String digest(String source) {
        return DigestHelper.digest(getMessageDigest(), source);
    }


    @Override
    public String digest(byte[] source) {
        return DigestHelper.digest(getMessageDigest(), source);
    }
}