package com.ec.primus.commons.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;


@ApiModel(description = "操作者")
public class OperatorVO
        implements java.io.Serializable {
    @ApiModelProperty(value = "操作者身份标识", example = "1")
    private String id;
    @ApiModelProperty(value = "操作者名称", example = "开发")
    private String name;
    @ApiModelProperty(value = "操作时的ip", example = "127.0.0.1")
    private String ip;

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    private OperatorVO(String id, String name, String ip) {
        this.id = id;
        this.name = name;
        this.ip = ip;
    }

    public static OperatorVO of(String id, String name, String ip) {
        return new OperatorVO(id, name, ip);
    }


    public String getId() {
        return this.id;
    }


    public String getName() {
        return this.name;
    }


    public String getIp() {
        return this.ip;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, org.apache.commons.lang3.builder.ToStringStyle.JSON_STYLE);
    }

    public OperatorVO() {
    }
}