/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.support.rest;

import com.ec.primus.commons.utils.ValueUtils;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpServletHelper {
    public static final String X_FORWARDED_FOR = "X-FORWARDED-FOR";
    public static final String X_REAL_IP = "X-Real-IP";

    public static String getCookieValue(HttpServletRequest request, String key) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isEmpty((Object[])cookies)) {
            return null;
        }
        String value = null;
        for (Object cookie : cookies) {
            if (!cookie.getName().equals(key)) continue;
            value = cookie.getValue();
            break;
        }
        return value;
    }

    public static void putSessionValue(HttpServletRequest request, String key, Object value) {
        request.getSession().setAttribute(key, value);
    }

    public static <T> T getSessionValue(HttpServletRequest request, String key) {
        Object value = request.getSession().getAttribute(key);
        return (T)value;
    }

    public static boolean getBooleanValueFromSession(HttpServletRequest request, String key) {
        Boolean booleanValue = (Boolean)HttpServletHelper.getSessionValue(request, key);
        return ValueUtils.getValue(booleanValue, Boolean.FALSE);
    }

    public static void setCookie(HttpServletResponse response, String key, String value, int expireSeconds, String path, Boolean httpOnly) {
        Cookie cookie = new Cookie(key, value);
        cookie.setMaxAge(expireSeconds);
        cookie.setPath(path);
        cookie.setHttpOnly(ValueUtils.getValue(httpOnly, Boolean.TRUE).booleanValue());
        response.addCookie(cookie);
    }

    public static void setCookie(HttpServletResponse response, String key, String value, int expireSeconds, String path) {
        HttpServletHelper.setCookie(response, key, value, expireSeconds, path, Boolean.TRUE);
    }

    public static String getClientIP(HttpServletRequest request) {
        String ipAddress = request.getHeader(X_FORWARDED_FOR);
        if (ipAddress == null) {
            String xRealIp = request.getHeader(X_REAL_IP);
            return StringUtils.isBlank((CharSequence)xRealIp) ? request.getRemoteHost() : xRealIp;
        }
        return ipAddress;
    }

    public static String getRequestURIWithParameters(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString();
        return StringUtils.isBlank((CharSequence)queryString) ? requestURI : String.format("%s?%s", requestURI, queryString);
    }

    public static Map<String, String> getHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        HashMap headers = Maps.newHashMap();
        while (headerNames.hasMoreElements()) {
            String nextHeader = headerNames.nextElement().toString();
            String nextHeaderValue = request.getHeader(nextHeader);
            headers.put(nextHeader, nextHeaderValue);
        }
        return headers;
    }
}

