/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils;

import com.ec.primus.commons.exception.CommonExceptions;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.web.context.ContextLoader;

public class SpringContextUtils
implements ApplicationContextAware {
    private static ApplicationContext APPLICATION_CONTEXT;

    public SpringContextUtils() {
    }

    public SpringContextUtils(ApplicationContext applicationContext) {
        if (APPLICATION_CONTEXT != null) {
            return;
        }
        AssertUtils.notNull((Object)applicationContext, (ExceptionType)CommonExceptions.PARAM_ERROR, "ApplicationContext is null");
        APPLICATION_CONTEXT = applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        APPLICATION_CONTEXT = applicationContext;
    }

    private static ApplicationContext getApplicationContext() {
        if (APPLICATION_CONTEXT == null) {
            APPLICATION_CONTEXT = ContextLoader.getCurrentWebApplicationContext();
        }
        return APPLICATION_CONTEXT;
    }

    public static <T> T getBean(Class<T> beanType) {
        return (T)(SpringContextUtils.getApplicationContext() == null ? null : SpringContextUtils.getApplicationContext().getBean(beanType));
    }

    public static Object getBean(String beanName) {
        return SpringContextUtils.getApplicationContext() == null ? null : SpringContextUtils.getApplicationContext().getBean(beanName);
    }

    public static List findBeansByAnnotation(Class<? extends Annotation> annotationClass) {
        ApplicationContext applicationContext = SpringContextUtils.getApplicationContext();
        if (applicationContext == null) {
            return Collections.EMPTY_LIST;
        }
        Map beanMaps = applicationContext.getBeansWithAnnotation(annotationClass);
        if (MapUtils.isEmpty((Map)beanMaps)) {
            return Collections.EMPTY_LIST;
        }
        return Lists.newArrayList(beanMaps.values());
    }

    public static <A extends Annotation> A findAnnotationFromBean(Class<A> annotationClass) {
        List beansWithAnnotation = SpringContextUtils.findBeansByAnnotation(annotationClass);
        if (CollectionUtils.isNotEmpty((Collection)beansWithAnnotation)) {
            Object next = beansWithAnnotation.iterator().next();
            return (A)AnnotationUtils.findAnnotation(next.getClass(), annotationClass);
        }
        return null;
    }

    public static Boolean isSpringValue(String key) {
        return key != null && (key.startsWith("${") || key.startsWith("#{") && key.endsWith("}"));
    }

    public static String getProperty(String propertyKey) {
        return SpringContextUtils.getProperty(propertyKey, null);
    }

    public static String getProperty(String propertyKey, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)propertyKey)) {
            return null;
        }
        Environment environment = SpringContextUtils.getBean(Environment.class);
        if (environment == null) {
            return null;
        }
        String key = propertyKey;
        String defaultReturnValue = defaultValue;
        if (SpringContextUtils.isSpringValue(propertyKey).booleanValue()) {
            key = propertyKey.substring(2, propertyKey.length() - 1);
            if (propertyKey.contains(":")) {
                String[] keyAndDefaultValue = key.split(":");
                key = keyAndDefaultValue[0];
                defaultReturnValue = keyAndDefaultValue[1];
            }
        }
        return environment.getProperty(key, defaultReturnValue);
    }
}

