/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils.bean;

import com.ec.primus.commons.utils.bean.CopyUtils;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public class Copier {
    private final Object source;
    private Table<Class, Class, Converter> converterTable = HashBasedTable.create();
    private boolean ignoreNullValue = false;
    private String[] ignoreProperties = new String[0];

    private Copier(Object source) {
        this.source = source;
    }

    public static Copier from(Object source) {
        return new Copier(source);
    }

    public <S, T> Copier usePropertyConverter(Converter<S, T> converter) {
        Assert.notNull(converter, (String)"\u5c5e\u6027\u8f6c\u6362\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        ResolvableType resolvableType = ResolvableType.forInstance(converter);
        ResolvableType[] generics = resolvableType.getGenerics();
        Assert.isTrue((generics.length == 2 ? 1 : 0) != 0, (String)"converter\u7684\u6cdb\u578b\u6570\u91cf\u5fc5\u987b\u4e3a2");
        this.converterTable.put((Object)generics[0].getRawClass(), (Object)generics[1].getRawClass(), converter);
        return this;
    }

    public Copier ignoreNullValue() {
        this.ignoreNullValue = true;
        return this;
    }

    public Copier ignoreProperties(String ... propertyNames) {
        this.ignoreProperties = (String[])ArrayUtils.clone((Object[])propertyNames);
        return this;
    }

    public <T> T to(T target) {
        Assert.notNull(target, (String)"target\u4e0d\u80fd\u4e3anull");
        return CopyUtils.copyProperties(this.source, target, this.ignoreNullValue, this.converterTable, this.ignoreProperties);
    }

    public <T> T to(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"supplier\u4e0d\u80fd\u4e3anull");
        return this.to(supplier.get());
    }
}

