/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils.bean;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.util.Assert;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class GenericClassUtils {
    public static Class getGenericTypeFromInterface(Class targetClass, int index) {
        return GenericClassUtils.getGenericTypeFromInterface(targetClass, null, index);
    }

    public static Class getGenericTypeFromInterface(Class targetClass, Class interfaceClass, int index) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = targetClass.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType) || interfaceClass != null && !((ParameterizedTypeImpl)genericInterface).getRawType().equals(interfaceClass)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
            return GenericClassUtils.getActualTypeArgumentClass(parameterizedType, index);
        }
        return Object.class;
    }

    public static Class getGenericTypeFromSuperClass(Class targetClass, int index) {
        Type superType = targetClass.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)superType;
            return GenericClassUtils.getActualTypeArgumentClass(parameterizedType, index);
        }
        return Object.class;
    }

    private static Class getActualTypeArgumentClass(ParameterizedType parameterizedType, int index) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Assert.isTrue((actualTypeArguments.length > index ? 1 : 0) != 0, (String)("Number of type arguments must be great or equals " + index));
        return (Class)actualTypeArguments[index];
    }
}

