/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.commons.utils.security;

import com.ec.primus.commons.utils.security.DigestHelper;
import com.ec.primus.commons.utils.security.IDigestUtils;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;

public class MD5Utils
implements IDigestUtils {
    private static final ThreadLocal<MessageDigest> MESSAGE_DIGEST_THREAD_LOCAL = new ThreadLocal();

    private static MessageDigest getMessageDigest() {
        if (MESSAGE_DIGEST_THREAD_LOCAL.get() == null) {
            MESSAGE_DIGEST_THREAD_LOCAL.set(DigestUtils.getMd5Digest());
        }
        return MESSAGE_DIGEST_THREAD_LOCAL.get();
    }

    public static MD5Utils instance() {
        return Md5UtilsInstanceHolder.INSTANCE;
    }

    @Override
    public String digest(File source) throws IOException {
        return DigestHelper.digest(MD5Utils.getMessageDigest(), source);
    }

    @Override
    public String digest(String source) {
        return DigestHelper.digest(MD5Utils.getMessageDigest(), source);
    }

    @Override
    public String digest(byte[] source) {
        return DigestHelper.digest(MD5Utils.getMessageDigest(), source);
    }

    private static class Md5UtilsInstanceHolder {
        private static final MD5Utils INSTANCE = new MD5Utils();

        private Md5UtilsInstanceHolder() {
        }
    }
}

