/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.es.common;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import org.elasticsearch.ElasticsearchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.repository.support.AbstractElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.data.elasticsearch.repository.support.MappingElasticsearchEntityInformation;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.util.Assert;

@NoRepositoryBean
public class CommonESRepositoryBean<T, ID extends Serializable>
extends AbstractElasticsearchRepository<T, ID> {
    private static final Logger log = LoggerFactory.getLogger(CommonESRepositoryBean.class);

    public CommonESRepositoryBean(ElasticsearchEntityInformation<T, ID> metadata, ElasticsearchOperations elasticsearchOperations) {
        super(metadata, elasticsearchOperations);
    }

    public CommonESRepositoryBean(ElasticsearchOperations elasticsearchOperations) {
        super(elasticsearchOperations);
        Class entityClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.setEntityClass(entityClass);
        this.entityInformation = this.getEntityInformation(elasticsearchOperations, entityClass);
        try {
            if (this.createIndexAndMapping()) {
                this.createIndex();
                this.putMapping();
            }
        }
        catch (ElasticsearchException exception) {
            log.error("failed to load elasticsearch nodes : " + exception.getDetailedMessage());
        }
    }

    public <T, ID extends Serializable> ElasticsearchEntityInformation<T, ID> getEntityInformation(ElasticsearchOperations elasticsearchOperations, Class<T> domainClass) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)elasticsearchOperations.getElasticsearchConverter().getMappingContext().getPersistentEntity(domainClass);
        Assert.notNull((Object)persistentEntity, (String)String.format("Unable to obtain mapping metadata for %s!", domainClass));
        Assert.notNull((Object)persistentEntity.getIdProperty(), (String)String.format("No id property found for %s!", domainClass));
        return new MappingElasticsearchEntityInformation(persistentEntity);
    }

    private void createIndex() {
        this.elasticsearchOperations.createIndex(this.getEntityClass());
    }

    private void putMapping() {
        this.elasticsearchOperations.putMapping(this.getEntityClass());
    }

    private boolean createIndexAndMapping() {
        return this.elasticsearchOperations.getPersistentEntityFor(this.getEntityClass()).isCreateIndexAndMapping();
    }

    protected String stringIdRepresentation(ID id) {
        return id.toString();
    }

    public String getIndexName() {
        return this.entityInformation.getIndexName();
    }

    public String getType() {
        return this.entityInformation.getType();
    }
}

