/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.es.common;

import com.ec.primus.es.common.CommonESRepositoryBean;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchRepositoryFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;

public class CommonESRepositoryFactory
extends ElasticsearchRepositoryFactory {
    private ElasticsearchOperations elasticsearchOperations;

    public CommonESRepositoryFactory(ElasticsearchOperations elasticsearchOperations) {
        super(elasticsearchOperations);
        this.elasticsearchOperations = elasticsearchOperations;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.getEntityInformation(metadata.getDomainType()), this.elasticsearchOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        if (CommonESRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            throw new IllegalArgumentException("QueryDsl Support has not been implemented yet.");
        }
        if (Integer.class.isAssignableFrom(metadata.getIdType()) || Long.class.isAssignableFrom(metadata.getIdType()) || Double.class.isAssignableFrom(metadata.getIdType()) || metadata.getIdType() == String.class) {
            return CommonESRepositoryBean.class;
        }
        throw new IllegalArgumentException("Unsupported ID type " + metadata.getIdType());
    }
}

