/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.es.common;

import com.ec.primus.es.common.CommonESRepositoryFactory;
import java.io.Serializable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.repository.ElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchRepositoryFactoryBean;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class CommonESRepositoryFactoryBean<T extends ElasticsearchRepository<Object, Serializable>>
extends ElasticsearchRepositoryFactoryBean<T, Object, Serializable> {
    private ElasticsearchOperations operations;

    public CommonESRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setElasticsearchOperations(ElasticsearchOperations operations) {
        Assert.notNull((Object)operations, (String)"Elasticsearch Operations can not be null.");
        this.setMappingContext(operations.getElasticsearchConverter().getMappingContext());
        this.operations = operations;
        super.setElasticsearchOperations(operations);
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new CommonESRepositoryFactory(this.operations);
    }
}

