/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.es.util;

import com.ec.primus.commons.utils.ValueUtils;
import com.ec.primus.es.util.ElasticSearchResultPage;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class PageUtil {
    private static final int DEFAULT_PAGE_NO = 0;
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final Integer PAGE_SIZE = 1000;

    public static PageRequest getPageResult(Integer currentPage, Integer pageSize) {
        Integer fixedCurrentPage = Math.max(0, ValueUtils.getValue((Integer)currentPage));
        Integer fixedPageSize = Math.max(10, ValueUtils.getValue((Integer)pageSize));
        return new PageRequest(fixedCurrentPage.intValue(), fixedPageSize.intValue());
    }

    public static PageRequest getPageResult(Integer currentPage, Integer pageSize, Sort sort) {
        if (currentPage == null) {
            currentPage = 0;
        } else if (currentPage < 0) {
            currentPage = 0;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        return new PageRequest(currentPage.intValue(), pageSize.intValue(), sort);
    }

    public static ElasticSearchResultPage getEsPage(Integer currentPage, Integer pageSize) {
        currentPage = currentPage < 0 ? 0 : currentPage;
        return new ElasticSearchResultPage(currentPage * pageSize, pageSize);
    }
}

