package com.ec.primus.excel.bean;

import com.ec.primus.excel.annotation.ExcelColumn;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * Excel列转换信息
 *
 * @author ning.zhang
 * @date 2021/8/26
 */
@Getter
@Setter
@Accessors(chain = true)
public class ExcelColumnConversion {

    /**
     * 数据字段名称映射
     */
    private Map<String, Pair<Field, ExcelColumn>> fieldNameDataMap;
    /**
     * 数据字段列号映射
     */
    private Map<Integer, Pair<Field, ExcelColumn>> fieldNumberDataMap;
    /**
     * 表格字段名称映射
     */
    private Map<String, Cell> fieldNameCellMap;
    /**
     * 表格字段列号映射
     */
    private Map<Integer, Cell> fieldNumberCellMap;

}
