package com.ec.primus.excel.exception;

import com.ec.primus.commons.exception.ExceptionType;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * excel异常枚举
 *
 * @author ning.zhang
 * @date 2021/9/10
 */
@Getter
@AllArgsConstructor
public enum ExcelExceptionType implements ExceptionType {

    //excel异常枚举取值
    NOT_HAVE_RECEIVE_DATA_FIELD(3, "没有可接收数据的字段!"),
    DATA_LINE_ANNOTATION_IS_EMPTY(4, "数据行号注解为空!"),
    EXCEL_SHEET_IS_EMPTY(5, "excel的sheet空间为空!"),
    EXCEL_DATA_FIELD_NAME_EXIST(6, "excel数据存在相同名称字段!"),
    EXCEL_DATA_FIELD_NUMBER_EXIST(7, "excel数据存在相同列号字段!"),
    EXCEL_FIELD_NAME_EXIST(8, "excel表格存在相同名称字段!"),
    EXCEL_FIELD_NUMBER_EXIST(9, "excel表格存在相同列号字段!"),
    ;

    private int code;
    private String description;
}
