/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.excel.util;

import com.ec.primus.commons.enums.DescribableEnum;
import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.commons.utils.AssertUtils;
import com.ec.primus.excel.annotation.ExcelColumn;
import com.ec.primus.excel.annotation.ExcelColumnDataFormat;
import com.ec.primus.excel.annotation.ExcelDataColumn;
import com.ec.primus.excel.annotation.ExcelFieldCheck;
import com.ec.primus.excel.annotation.ExcelSheetName;
import com.ec.primus.excel.bean.ExcelCheckConversion;
import com.ec.primus.excel.bean.ExcelColumnConversion;
import com.ec.primus.excel.bean.ExcelFieldErrorInfo;
import com.ec.primus.excel.bean.ExcelFieldInfo;
import com.ec.primus.excel.bean.ExcelTemplate;
import com.ec.primus.excel.enums.ExcelFieldCheckErrorType;
import com.ec.primus.excel.exception.ExcelExceptionType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelExportUtil {
    private ExcelExportUtil() {
    }

    public static ExcelExportUtil newInstance() {
        return ExcelExportUtilHolder.instance;
    }

    public void exportDataListToBook(List<? extends ExcelTemplate> dataList, Workbook dataBook, List<Integer> deleteColumns) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        this.deleteColumn(dataBook, deleteColumns);
        if (CollectionUtils.isNotEmpty(dataList)) {
            this.buildWorkbook(dataList, dataBook, deleteColumns);
        }
    }

    private void buildWorkbook(List<? extends ExcelTemplate> dataList, Workbook dataBook, List<Integer> deleteColumns) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        XSSFSheet templateSheet;
        Sheet sheet;
        Class<?> clazz = dataList.get(0).getClass();
        ExcelColumnConversion excelColumnConversion = new ExcelColumnConversion();
        this.buildAnnotationFieldMap(excelColumnConversion, clazz);
        ExcelSheetName excelSheetName = clazz.getAnnotation(ExcelSheetName.class);
        if (excelSheetName != null && StringUtils.isNotBlank((CharSequence)excelSheetName.name())) {
            sheet = dataBook.getSheet(excelSheetName.name());
            templateSheet = ((SXSSFWorkbook)dataBook).getXSSFWorkbook().getSheet(excelSheetName.name());
        } else {
            sheet = dataBook.getSheetAt(0);
            templateSheet = ((SXSSFWorkbook)dataBook).getXSSFWorkbook().getSheetAt(0);
        }
        AssertUtils.isTrue((sheet != null ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.EXCEL_SHEET_IS_EMPTY);
        AssertUtils.isTrue((!excelColumnConversion.getFieldNameDataMap().isEmpty() ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.NOT_HAVE_RECEIVE_DATA_FIELD);
        ExcelDataColumn excelDataColumn = clazz.getAnnotation(ExcelDataColumn.class);
        AssertUtils.isTrue((excelDataColumn != null && excelDataColumn.dataNumber() >= 1 ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.DATA_LINE_ANNOTATION_IS_EMPTY);
        this.buildExcelCellMap(excelColumnConversion, (Sheet)templateSheet, excelDataColumn);
        AssertUtils.isTrue((!excelColumnConversion.getFieldNameCellMap().isEmpty() ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.NOT_HAVE_RECEIVE_DATA_FIELD);
        for (int rowNum = 0; rowNum < dataList.size(); ++rowNum) {
            Row rowAnother = sheet.createRow(rowNum + excelDataColumn.dataNumber());
            this.writeDataToCell(excelColumnConversion, dataList, clazz, dataBook, rowNum, rowAnother, deleteColumns);
        }
        sheet.setForceFormulaRecalculation(true);
    }

    private void buildExcelCellMap(ExcelColumnConversion excelColumnConversion, Sheet templateSheet, ExcelDataColumn excelDataColumn) {
        int fieldNumber = excelDataColumn.fieldNumber();
        Row fieldRow = templateSheet.getRow(fieldNumber);
        HashMap fieldNameCellMap = Maps.newHashMap();
        HashMap fieldNumberCellMap = Maps.newHashMap();
        for (Cell cell : fieldRow) {
            Cell nameCell = (Cell)fieldNameCellMap.get(cell.getStringCellValue());
            AssertUtils.isNull((Object)nameCell, (ExceptionType)ExcelExceptionType.EXCEL_FIELD_NAME_EXIST);
            fieldNameCellMap.put(cell.getStringCellValue(), cell);
            fieldNumberCellMap.put(cell.getColumnIndex(), cell);
        }
        excelColumnConversion.setFieldNameCellMap(fieldNameCellMap);
        excelColumnConversion.setFieldNumberCellMap(fieldNumberCellMap);
    }

    private void buildAnnotationFieldMap(ExcelColumnConversion excelColumnConversion, Class<? extends ExcelTemplate> clazz) {
        Field[] fields;
        HashMap fieldNameMap = Maps.newHashMap();
        HashMap fieldNumberMap = Maps.newHashMap();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            if (excelColumn == null) continue;
            Pair namePair = (Pair)fieldNameMap.get(excelColumn.name());
            AssertUtils.isNull((Object)namePair, (ExceptionType)ExcelExceptionType.EXCEL_DATA_FIELD_NAME_EXIST);
            fieldNameMap.put(excelColumn.name(), Pair.of((Object)field, (Object)excelColumn));
            if (excelColumn.columnNumber() < 0) continue;
            Pair numberPair = (Pair)fieldNumberMap.get(excelColumn.columnNumber());
            AssertUtils.isNull((Object)numberPair, (ExceptionType)ExcelExceptionType.EXCEL_DATA_FIELD_NUMBER_EXIST);
            fieldNumberMap.put(excelColumn.columnNumber(), Pair.of((Object)field, (Object)excelColumn));
        }
        excelColumnConversion.setFieldNameDataMap(fieldNameMap);
        excelColumnConversion.setFieldNumberDataMap(fieldNumberMap);
    }

    private void writeDataToCell(ExcelColumnConversion excelColumnConversion, List<? extends ExcelTemplate> dataList, Class<? extends ExcelTemplate> clazz, Workbook templateBook, int rowNum, Row rowAnother, List<Integer> deleteColumns) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        for (Map.Entry<String, Cell> entry : excelColumnConversion.getFieldNameCellMap().entrySet()) {
            Pair<Field, ExcelColumn> namePair = excelColumnConversion.getFieldNameDataMap().get(entry.getKey());
            Pair<Field, ExcelColumn> numberPair = excelColumnConversion.getFieldNumberDataMap().get(entry.getValue().getColumnIndex());
            Pair<Field, ExcelColumn> fieldExcelColumnPair = numberPair != null ? numberPair : namePair;
            if (fieldExcelColumnPair == null || deleteColumns.contains(entry.getValue().getColumnIndex())) continue;
            Field annotationField = (Field)fieldExcelColumnPair.getLeft();
            PropertyDescriptor pd = new PropertyDescriptor(annotationField.getName(), clazz);
            Method method = pd.getReadMethod();
            Object object = method.invoke((Object)dataList.get(rowNum), new Object[0]);
            ExcelColumn excelColumn = annotationField.getAnnotation(ExcelColumn.class);
            Class aClass = excelColumn.dataClass();
            ExcelColumnDataFormat dataFormat = annotationField.getAnnotation(ExcelColumnDataFormat.class);
            Cell cell = rowAnother.createCell(entry.getValue().getColumnIndex());
            this.buildCellDataFormat(templateBook, object, aClass, dataFormat, cell);
        }
    }

    private void buildCellDataFormat(Workbook templateBook, Object object, Class aClass, ExcelColumnDataFormat dataFormat, Cell cell) {
        if (dataFormat != null && StringUtils.isNotBlank((CharSequence)dataFormat.dataFormat())) {
            CellStyle style = templateBook.createCellStyle();
            DataFormat format = templateBook.createDataFormat();
            style.setDataFormat(format.getFormat(dataFormat.dataFormat()));
            cell.setCellStyle(style);
        }
        if (aClass == Integer.class) {
            cell.setCellValue((double)((Integer)object).intValue());
        } else if (aClass == Long.class) {
            cell.setCellValue((double)((Long)object).longValue());
        } else if (aClass == Double.class) {
            cell.setCellValue(((Double)object).doubleValue());
        } else if (aClass == Date.class) {
            cell.setCellValue((Date)object);
        } else if (object instanceof DescribableEnum) {
            cell.setCellValue(((DescribableEnum)object).getDesc());
        } else {
            cell.setCellValue(object == null ? "" : object.toString());
        }
    }

    private void deleteColumn(Workbook templateBook, List<Integer> deleteColumns) {
        if (CollectionUtils.isNotEmpty(deleteColumns)) {
            XSSFSheet sheet = ((SXSSFWorkbook)templateBook).getXSSFWorkbook().getSheetAt(0);
            deleteColumns.forEach(arg_0 -> this.lambda$deleteColumn$0((Sheet)sheet, arg_0));
        }
    }

    private void cloneCell(Cell cNew, Cell cOld) {
        cNew.setCellComment(cOld.getCellComment());
        cNew.setCellStyle(cOld.getCellStyle());
        if (CellType.BOOLEAN == cNew.getCellTypeEnum()) {
            cNew.setCellValue(cOld.getBooleanCellValue());
        } else if (CellType.NUMERIC == cNew.getCellTypeEnum()) {
            cNew.setCellValue(cOld.getNumericCellValue());
        } else if (CellType.STRING == cNew.getCellTypeEnum()) {
            cNew.setCellValue(cOld.getStringCellValue());
        } else if (CellType.ERROR == cNew.getCellTypeEnum()) {
            cNew.setCellValue((double)cOld.getErrorCellValue());
        } else if (CellType.FORMULA == cNew.getCellTypeEnum()) {
            cNew.setCellValue(cOld.getCellFormula());
        }
    }

    public <T extends ExcelTemplate> List<T> importBookToDataList(Workbook workbook, Class<T> clazz) throws IllegalAccessException, InstantiationException, IntrospectionException, InvocationTargetException {
        ArrayList listObject = Lists.newArrayList();
        ExcelDataColumn excelDataColumn = clazz.getAnnotation(ExcelDataColumn.class);
        AssertUtils.isTrue((excelDataColumn != null && excelDataColumn.dataNumber() >= 1 ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.DATA_LINE_ANNOTATION_IS_EMPTY);
        ExcelSheetName excelSheetName = clazz.getAnnotation(ExcelSheetName.class);
        Sheet sheet = excelSheetName != null && StringUtils.isNotBlank((CharSequence)excelSheetName.name()) ? workbook.getSheet(excelSheetName.name()) : workbook.getSheetAt(0);
        ExcelColumnConversion excelColumnConversion = new ExcelColumnConversion();
        this.buildAnnotationFieldMap(excelColumnConversion, clazz);
        AssertUtils.isTrue((!excelColumnConversion.getFieldNameDataMap().isEmpty() ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.NOT_HAVE_RECEIVE_DATA_FIELD);
        this.buildExcelCellMap(excelColumnConversion, sheet, excelDataColumn);
        AssertUtils.isTrue((!excelColumnConversion.getFieldNameCellMap().isEmpty() ? 1 : 0) != 0, (ExceptionType)ExcelExceptionType.NOT_HAVE_RECEIVE_DATA_FIELD);
        for (int rowIndex = 0; rowIndex < sheet.getPhysicalNumberOfRows(); ++rowIndex) {
            Row dataRow = sheet.getRow(rowIndex + excelDataColumn.dataNumber());
            if (dataRow == null) continue;
            ExcelTemplate obj = (ExcelTemplate)clazz.newInstance();
            obj.setLineNumber(dataRow.getRowNum() + 1);
            this.writeDataToObject(clazz, excelColumnConversion, dataRow, obj);
            listObject.add(obj);
        }
        return listObject;
    }

    private <T> void writeDataToObject(Class<T> clazz, ExcelColumnConversion excelColumnConversion, Row dataRow, T obj) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        for (Map.Entry<String, Pair<Field, ExcelColumn>> entry : excelColumnConversion.getFieldNameDataMap().entrySet()) {
            Cell fieldNameCell;
            Cell nameCell = excelColumnConversion.getFieldNameCellMap().get(entry.getKey());
            Cell numberCell = excelColumnConversion.getFieldNumberCellMap().get(((ExcelColumn)entry.getValue().getRight()).columnNumber());
            Cell cell = fieldNameCell = numberCell != null ? numberCell : nameCell;
            if (fieldNameCell == null) continue;
            Field field = (Field)entry.getValue().getLeft();
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
            Cell cell2 = dataRow.getCell(fieldNameCell.getColumnIndex());
            if (cell2 == null) continue;
            Method method = pd.getWriteMethod();
            Class aClass = excelColumn.dataClass();
            if (cell2.getCellTypeEnum() == CellType.STRING) {
                cell2.setCellValue(cell2.getStringCellValue().trim());
            }
            if (aClass == Integer.class) {
                int cellValue = cell2.getCellTypeEnum() == CellType.NUMERIC ? Double.valueOf(cell2.getNumericCellValue()).intValue() : Integer.parseInt(cell2.getStringCellValue());
                method.invoke(obj, cellValue);
                continue;
            }
            if (aClass == Long.class) {
                long cellValue = cell2.getCellTypeEnum() == CellType.NUMERIC ? Double.valueOf(cell2.getNumericCellValue()).longValue() : Long.parseLong(cell2.getStringCellValue());
                method.invoke(obj, cellValue);
                continue;
            }
            if (aClass == Double.class) {
                double cellValue = cell2.getCellTypeEnum() == CellType.NUMERIC ? cell2.getNumericCellValue() : Double.parseDouble(cell2.getStringCellValue());
                method.invoke(obj, cellValue);
                continue;
            }
            if (aClass == Date.class) {
                method.invoke(obj, cell2.getDateCellValue());
                continue;
            }
            cell2.setCellType(CellType.STRING);
            method.invoke(obj, StringUtils.isNotBlank((CharSequence)cell2.getStringCellValue()) ? cell2.getStringCellValue() : cell2.getStringCellValue().trim());
        }
    }

    public <T extends ExcelTemplate> List<ExcelFieldErrorInfo> checkTemplateData(List<T> dataList) throws IntrospectionException, IllegalAccessException {
        Class<?> clazz;
        ExcelCheckConversion checkConversion;
        ArrayList errorList = Lists.newArrayList();
        if (!(!CollectionUtils.isNotEmpty(dataList) || (checkConversion = this.buildCheckFieldMap(clazz = ((ExcelTemplate)dataList.get(0)).getClass())).getFieldEmptyCheckMap().isEmpty() && checkConversion.getFieldRepeatCheckMap().isEmpty())) {
            HashMap uniqueDataMap = Maps.newHashMap();
            for (ExcelTemplate data : dataList) {
                this.checkEmptyData(errorList, checkConversion, data);
                this.checkRepeatData(errorList, checkConversion, uniqueDataMap, data);
            }
        }
        return errorList;
    }

    private <T extends ExcelTemplate> void checkEmptyData(List<ExcelFieldErrorInfo> errorList, ExcelCheckConversion checkConversion, T data) throws IllegalAccessException {
        Map<String, Field> fieldEmptyCheckMap = checkConversion.getFieldEmptyCheckMap();
        ArrayList fieldInfoList = Lists.newArrayList();
        for (Map.Entry<String, Field> entry : fieldEmptyCheckMap.entrySet()) {
            Field field = entry.getValue();
            field.setAccessible(true);
            Boolean emptyFlag = String.class == field.getType() ? Boolean.valueOf(field.get(data) == null || StringUtils.isBlank((CharSequence)String.valueOf(field.get(data)))) : Boolean.valueOf(field.get(data) == null);
            if (!Boolean.TRUE.equals(emptyFlag)) continue;
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            fieldInfoList.add(new ExcelFieldInfo().setFieldExcelName(excelColumn.name()).setFieldName(field.getName()).setFieldType(field.getType()).setFieldValue(field.get(data)));
        }
        if (CollectionUtils.isNotEmpty((Collection)fieldInfoList)) {
            errorList.add(new ExcelFieldErrorInfo().setErrorType(ExcelFieldCheckErrorType.EMPTY_OR_NULL).setLineNumber(data.getLineNumber()).setFieldInfoList(fieldInfoList));
        }
    }

    private <T extends ExcelTemplate> void checkRepeatData(List<ExcelFieldErrorInfo> errorList, ExcelCheckConversion checkConversion, Map<String, T> uniqueDataMap, T data) throws IllegalAccessException {
        Map<String, Field> repeatCheckMap = checkConversion.getFieldRepeatCheckMap();
        if (!repeatCheckMap.isEmpty()) {
            StringBuilder uniqueBuilder = new StringBuilder();
            for (Map.Entry<String, Field> entry : repeatCheckMap.entrySet()) {
                Field field = entry.getValue();
                field.setAccessible(true);
                uniqueBuilder.append(String.valueOf(field.get(data)));
            }
            String uniqueKey = uniqueBuilder.toString();
            ExcelTemplate t = (ExcelTemplate)uniqueDataMap.get(uniqueKey);
            if (t != null) {
                ArrayList fieldInfoList = Lists.newArrayList();
                for (Map.Entry<String, Field> entry : repeatCheckMap.entrySet()) {
                    Field field = entry.getValue();
                    field.setAccessible(true);
                    ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
                    fieldInfoList.add(new ExcelFieldInfo().setFieldExcelName(excelColumn.name()).setFieldName(entry.getValue().getName()).setFieldType(entry.getValue().getType()).setFieldValue(field.get(data)));
                }
                errorList.add(new ExcelFieldErrorInfo().setErrorType(ExcelFieldCheckErrorType.DATA_REPEAT).setLineNumber(data.getLineNumber()).setRepeatNumber(t.getLineNumber()).setFieldInfoList(fieldInfoList));
            } else {
                uniqueDataMap.put(uniqueBuilder.toString(), data);
            }
        }
    }

    private ExcelCheckConversion buildCheckFieldMap(Class<? extends ExcelTemplate> clazz) {
        Field[] fields;
        HashMap fieldEmptyCheckMap = Maps.newHashMap();
        HashMap fieldRepeatCheckMap = Maps.newHashMap();
        for (Field field : fields = clazz.getDeclaredFields()) {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            ExcelFieldCheck fieldCheck = field.getAnnotation(ExcelFieldCheck.class);
            if (excelColumn == null || fieldCheck == null) continue;
            if (Boolean.TRUE.equals(fieldCheck.emptyCheck())) {
                fieldEmptyCheckMap.put(field.getName(), field);
            }
            if (!Boolean.TRUE.equals(fieldCheck.uniqueJoin())) continue;
            fieldRepeatCheckMap.put(field.getName(), field);
        }
        return new ExcelCheckConversion().setFieldEmptyCheckMap(fieldEmptyCheckMap).setFieldRepeatCheckMap(fieldRepeatCheckMap);
    }

    private /* synthetic */ void lambda$deleteColumn$0(Sheet sheet, Integer columnToDelete) {
        Row row = sheet.getRow(0);
        for (int cID = columnToDelete.intValue(); cID < row.getLastCellNum(); ++cID) {
            Cell cNext;
            Cell cOld = row.getCell(cID);
            if (cOld != null) {
                row.removeCell(cOld);
            }
            if ((cNext = row.getCell(cID + 1)) == null) continue;
            Cell cNew = row.createCell(cID, cNext.getCellTypeEnum());
            this.cloneCell(cNew, cNext);
            sheet.setColumnWidth(cID, sheet.getColumnWidth(cID + 1));
        }
    }

    private static class ExcelExportUtilHolder {
        static ExcelExportUtil instance = new ExcelExportUtil();

        private ExcelExportUtilHolder() {
        }
    }
}

