/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.feign;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.feign.MSBusinessException;
import com.ec.primus.feign.SoaMessageCoder;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoaFeignErrorDecoder
implements ErrorDecoder {
    private static final Logger log = LoggerFactory.getLogger(SoaFeignErrorDecoder.class);
    private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();
    private SoaMessageCoder soaMessageCoder = new SoaMessageCoder();

    public Exception decode(String methodKey, Response response) {
        Collection errorCode;
        if (response.status() == 500 && (errorCode = (Collection)response.headers().get("X-Error-Code")) != null && !errorCode.isEmpty()) {
            Collection errorMsg = (Collection)response.headers().get("X-Error-Msg");
            Integer code = Integer.valueOf((String)errorCode.iterator().next());
            String msg = errorMsg == null ? "" : (String)errorMsg.iterator().next();
            log.trace("msg={}", (Object)msg);
            try {
                log.trace("msg={}", (Object)new String(msg.getBytes("UTF-8"), "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            msg = this.soaMessageCoder.decoder(msg);
            log.trace("decode msg={}", (Object)msg);
            return new MSBusinessException(new BusinessSilentException(code.intValue(), StringUtils.isBlank((CharSequence)msg) ? methodKey + " with empty msg" : msg));
        }
        return this.defaultErrorDecoder.decode(methodKey, response);
    }
}

