/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.feign.advice;

import com.ec.primus.commons.exception.BusinessException;
import com.ec.primus.feign.SoaMessageCoder;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ServiceBusinessExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ServiceBusinessExceptionAdvice.class);
    @Value(value="${spring.application.name}")
    private String serviceName;
    private SoaMessageCoder soaMessageCoder = new SoaMessageCoder();

    @ExceptionHandler(value={Exception.class})
    protected void exceptionHandler(Exception ex, HttpServletResponse response) {
        String errorMsg;
        int errorCode = 500;
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        if (ex instanceof BusinessException) {
            errorCode = ((BusinessException)ex).getCode();
            errorMsg = ((BusinessException)ex).getDescription();
            log.info("BusinessException.code={},msg={}", new Object[]{errorCode, errorMsg, ex});
        } else {
            errorMsg = "\u670d\u52a1\u5668\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u8bd5";
            log.error("unprocessed exception.", (Throwable)ex);
        }
        response.setStatus(500);
        response.addHeader("X-Error-Code", String.valueOf(errorCode));
        response.addHeader("X-Error-Msg", this.soaMessageCoder.encoder(errorMsg));
    }
}

