package com.ec.primus.jpa.config;

import com.alibaba.druid.pool.DruidDataSource;

import java.sql.SQLException;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;


@Configuration
@Component
public class DruidDataSourceConfig {
    @Value("${spring.datasource.url}")
    private String dbUrl;
    @Value("${spring.datasource.username}")
    private String username;
    @Value("${spring.datasource.password}")
    private String password;
    @Value("${spring.datasource.driverClassName}")
    private String driverClassName;
    @Value("${spring.datasource.druid.initialSize}")
    private Integer initialSize;
    @Value("${spring.datasource.druid.minIdle}")
    private Integer minIdle;
    @Value("${spring.datasource.druid.maxActive}")
    private Integer maxActive;
    @Value("${spring.datasource.druid.maxWait}")
    private Integer maxWait;
    @Value("${spring.datasource.druid.timeBetweenEvictionRunsMillis}")
    private Integer timeBetweenEvictionRunsMillis;
    @Value("${spring.datasource.druid.minEvictableIdleTimeMillis}")
    private Integer minEvictableIdleTimeMillis;
    @Value("${spring.datasource.druid.validationQuery}")
    private String validationQuery;
    @Value("${spring.datasource.druid.testWhileIdle}")
    private Boolean testWhileIdle;
    @Value("${spring.datasource.druid.testOnBorrow}")
    private Boolean testOnBorrow;
    @Value("${spring.datasource.druid.testOnReturn}")
    private Boolean testOnReturn;
    @Value("${spring.datasource.druid.poolPreparedStatements}")
    private Boolean poolPreparedStatements;
    @Value("${spring.datasource.druid.maxPoolPreparedStatementPerConnectionSize}")
    private Integer maxPoolPreparedStatementPerConnectionSize;
    @Value("${spring.datasource.druid.filters}")
    private String filters;
    @Value("${spring.datasource.druid.connectionProperties}")
    private String connectionProperties;
    @Value("${spring.datasource.druid.useGlobalDataSourceStat}")
    private Boolean useGlobalDataSourceStat;

    @Bean
    @Primary
    public DataSource dataSource() {
        DruidDataSource datasource = new DruidDataSource();

        datasource.setUrl(this.dbUrl);
        datasource.setUsername(this.username);
        datasource.setPassword(this.password);
        datasource.setDriverClassName(this.driverClassName);


        datasource.setInitialSize(this.initialSize == null ? 5 : this.initialSize);
        datasource.setMinIdle(this.minIdle == null ? 1 : this.minIdle);
        datasource.setMaxActive(this.maxActive == null ? 20 : this.minIdle);
        datasource.setMaxWait(this.maxWait == null ? 60000L : this.maxWait);
        datasource.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis == null ? 60000L : this.timeBetweenEvictionRunsMillis);
        datasource.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis == null ? 300000L : this.minEvictableIdleTimeMillis);
        datasource.setValidationQuery((this.validationQuery == null) || ("".equals(this.validationQuery.trim())) ? "SELECT 1 FROM DUAL" : this.validationQuery);
        datasource.setTestWhileIdle(this.testWhileIdle != null);
        datasource.setTestOnBorrow(this.testOnBorrow != null);
        datasource.setTestOnReturn(this.testOnReturn != null);
        datasource.setPoolPreparedStatements(this.poolPreparedStatements != null);
        datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize == null ? 20 : this.maxPoolPreparedStatementPerConnectionSize);
        try {
            datasource.setFilters((this.filters == null) || ("".equals(this.filters.trim())) ? "stat,wall,log4j" : this.filters);
        } catch (SQLException localSQLException) {
        }
        datasource.setConnectionProperties((this.connectionProperties == null) || ("".equals(this.connectionProperties.trim())) ? "druid.stat.mergeSql=true;druid.stat.slowSqlMillis=5000" : this.connectionProperties);
        datasource.setUseGlobalDataSourceStat(this.useGlobalDataSourceStat != null);

        return datasource;
    }
}
