package com.ec.primus.jpa.converter;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import java.io.Serializable;
import java.util.*;
import javax.persistence.AttributeConverter;

import org.apache.commons.lang3.StringUtils;


public abstract class AbstractSetStringConverter<E>
        extends Converter<Set<E>, String>
        implements AttributeConverter<Set<E>, String>, Serializable {
    public static final String separator = ",";

    public AbstractSetStringConverter() {
    }

    @Override
    @Deprecated
    public String convertToDatabaseColumn(Set<E> set) {
        return this.toString(set);
    }

    @Override
    @Deprecated
    public Set<E> convertToEntityAttribute(String dbData) {
        return (Set)(StringUtils.isBlank(dbData)?new HashSet():this.toSet(dbData));
    }

    public String toString(Set<E> set) {
        if(set == null) {
            return "";
        } else {
            Set<String> stringSet = Sets.newHashSet();
            Iterator var3 = set.iterator();

            while(var3.hasNext()) {
                E e = (E) var3.next();
                String str = this.element2String(e);
                if(str != null) {
                    stringSet.add(str);
                }
            }

            return Joiner.on(",").join(set);
        }
    }

    public Set<E> toSet(String string) {
        if(StringUtils.isBlank(string)) {
            return Collections.emptySet();
        } else {
            List<String> eles = Splitter.on(",").splitToList(string);
            return Sets.newHashSet(Lists.transform(eles, new Function<String, E>() {
                @Override
                public E apply(String input) {
                    return AbstractSetStringConverter.this.string2Element(input);
                }
            }));
        }
    }

    protected abstract E string2Element(String var1);

    protected String element2String(E ele) {
        return ele != null?ele.toString():null;
    }

    @Override
    protected String doForward(Set<E> a) {
        return this.toString(a);
    }

    @Override
    protected Set<E> doBackward(String b) {
        return this.toSet(b);
    }
}