package com.ec.primus.jpa.po;

import lombok.Data;
import org.hibernate.annotations.UpdateTimestamp;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;


@MappedSuperclass
@Data
public class BaseEntity extends BasePo {

    @Id
    @Column(length = 80)
    private String id;

    private Timestamp createTime = new Timestamp(System.currentTimeMillis());

    @UpdateTimestamp
    private Timestamp updateTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != getClass()) {
            return false;
        }
        BaseEntity that = (BaseEntity) o;
        return Objects.equals(this.id, that.id);
    }


    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id});
    }

    @Override
    public String toString() {
        return getClass().getName() + "#" + getId();
    }
}
