package com.ec.primus.jpa.po;

import java.sql.Timestamp;
import javax.persistence.GeneratedValue;

import com.ec.primus.commons.jackson.annotation.Stringify;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.UpdateTimestamp;

@javax.persistence.MappedSuperclass
@Getter
@Setter
public class BaseEntityPKIncrement extends BasePo implements java.io.Serializable {

    @javax.persistence.Id
    @GeneratedValue(strategy = javax.persistence.GenerationType.IDENTITY)
    private String id;

    private Timestamp createTimestamp = new Timestamp(System.currentTimeMillis());

    @UpdateTimestamp
    private Timestamp updateTimestamp;

    @Override
    public String toString() {
        return

                new ToStringBuilder(this).append("id", this.id).toString();
    }
}