/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.jpa.converter;

import com.ec.primus.commons.exception.BusinessSilentException;
import java.io.UnsupportedEncodingException;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.ArrayUtils;

public class LargeStringConverter
implements AttributeConverter<String, byte[]> {
    public byte[] convertToDatabaseColumn(String attribute) {
        try {
            return attribute == null ? null : attribute.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessSilentException("Unsupported charset.");
        }
    }

    public String convertToEntityAttribute(byte[] dbData) {
        try {
            return ArrayUtils.isEmpty((byte[])dbData) ? null : new String(dbData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BusinessSilentException("Unsupported charset.");
        }
    }
}

