package com.ec.primus.jpa.converter;

import com.ec.primus.commons.utils.JsonUtils;

import java.io.Serializable;
import javax.persistence.AttributeConverter;


public abstract class AbstractJsonConverter<T>
        implements AttributeConverter<T, String>, Serializable {
    public abstract Class<T> getTargetClass();

    @Override
    public String convertToDatabaseColumn(T attribute) {
        return JsonUtils.obj2Json(attribute);
    }


    @Override
    public T convertToEntityAttribute(String dbData) {
        return (T) JsonUtils.json2Obj(dbData, getTargetClass());
    }
}
