package com.ec.primus.jpa.converter;

import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.AttributeConverter;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;


public abstract class AbstractListStringConverter<E>
        extends Converter<List<E>, String>
        implements AttributeConverter<List<E>, String>, Serializable {
    public static final String separator = ",";
    private static final long serialVersionUID = -7609608603310118266L;

    @Override
    @Deprecated
    public String convertToDatabaseColumn(List<E> list) {
        return toString(list);
    }


    @Override
    @Deprecated
    public List<E> convertToEntityAttribute(String dbData) {
        if (StringUtils.isBlank(dbData)) {
            return Lists.newArrayList();
        }
        return toList(dbData);
    }

    public String toString(List<E> list) {
        if (list == null) {
            return "";
        }
        List<String> stringList = Lists.newArrayList();
        for (E e : list) {
            String str = element2String(e);
            if (str != null) {
                stringList.add(str);
            }
        }
        return Joiner.on(",").join(list);
    }

    public List<E> toList(String string) {
        if (StringUtils.isBlank(string)) {
            return Collections.emptyList();
        }
        List<String> list = Splitter.on(",").splitToList(string);
        List<E> result = Lists.newArrayList();
        for (String s : list) {
            result.add(string2Element(s));
        }
        return result;
    }

    @Override
    protected String doForward(List<E> a) {
        return toString(a);
    }

    @Override
    protected List<E> doBackward(String b) {
        return toList(b);
    }

    protected abstract E string2Element(String paramString);

    protected String element2String(E ele) {
        if (ele != null) {
            return ele.toString();
        }
        return null;
    }
}