package com.ec.primus.jpa.converter;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;

import com.ec.primus.commons.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class DefaultJsonConverter
        implements AttributeConverter<Object, String>, Serializable {
    private static final String DATA_TYPE = "dateType";
    private static final String DATA_JSON = "dataJson";

    @Override
    public String convertToDatabaseColumn(Object attribute) {
        if (attribute == null) {
            return null;
        }
        String dataType = attribute.getClass().getName();
        String dataJson = JsonUtils.obj2Json(attribute);
        Map<String, String> data = new LinkedHashMap();
        data.put("dateType", dataType);
        data.put("dataJson", dataJson);
        return JsonUtils.obj2Json(data);
    }


    @Override
    public Object convertToEntityAttribute(String dbData) {
        if (StringUtils.isBlank(dbData)) {
            return null;
        }
        Map dataInfo = (Map) JsonUtils.json2Obj(dbData, Map.class);
        Object dateType = dataInfo.get("dateType");
        Object dataJson = dataInfo.get("dataJson");
        try {
            Class<?> aClass = Class.forName(dateType.toString());
            return JsonUtils.json2Obj(dataJson.toString(), aClass);
        } catch (Exception e) {
            logger.warn("Parse json data:{} failed.", dbData, e);
        }
        return null;
    }


    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonConverter.class);
}