/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.jpa.converter;

import com.ec.primus.commons.utils.JsonUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.AttributeConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonConverter
implements AttributeConverter<Object, String>,
Serializable {
    private static final String DATA_TYPE = "dateType";
    private static final String DATA_JSON = "dataJson";
    private static final Logger logger = LoggerFactory.getLogger(DefaultJsonConverter.class);

    public String convertToDatabaseColumn(Object attribute) {
        if (attribute == null) {
            return null;
        }
        String dataType = attribute.getClass().getName();
        String dataJson = JsonUtils.obj2Json((Object)attribute);
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put(DATA_TYPE, dataType);
        data.put(DATA_JSON, dataJson);
        return JsonUtils.obj2Json(data);
    }

    public Object convertToEntityAttribute(String dbData) {
        if (StringUtils.isBlank((CharSequence)dbData)) {
            return null;
        }
        Map dataInfo = (Map)JsonUtils.json2Obj((String)dbData, Map.class);
        Object dateType = dataInfo.get(DATA_TYPE);
        Object dataJson = dataInfo.get(DATA_JSON);
        try {
            Class<?> aClass = Class.forName(dateType.toString());
            return JsonUtils.json2Obj((String)dataJson.toString(), aClass);
        }
        catch (Exception e) {
            logger.warn("Parse json data:{} failed.", (Object)dbData, (Object)e);
            return null;
        }
    }
}

