package com.ec.primus.jpa.converter;

import java.io.UnsupportedEncodingException;
import javax.persistence.AttributeConverter;

import com.ec.primus.commons.exception.BusinessSilentException;
import org.apache.commons.lang3.ArrayUtils;


public class LargeStringConverter
        implements AttributeConverter<String, byte[]> {
    @Override
    public byte[] convertToDatabaseColumn(String attribute) {
        try {
            return attribute == null ? null : attribute.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessSilentException("Unsupported charset.");
        }
    }


    @Override
    public String convertToEntityAttribute(byte[] dbData) {
        try {
            return ArrayUtils.isEmpty(dbData) ? null : new String(dbData, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            throw new BusinessSilentException("Unsupported charset.");
        }
    }
}
