/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class JedisHealthIndicator
extends AbstractHealthIndicator {
    private ShardedJedisPool shardedJedisPool;

    public JedisHealthIndicator(ShardedJedisPool shardedJedisPool) {
        this.shardedJedisPool = shardedJedisPool;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            List infoProperties = jedis.getAllShards().stream().map(j -> {
                String[] info = j.info().split("\\r\\n");
                return Arrays.stream(info).filter(StringUtils::isNotBlank).map(i -> i.split(":")).filter(i -> ((String[])i).length == 2).map(i -> {
                    if (NumberUtils.isParsable((String)i[1])) {
                        return Pair.of((Object)i[0], (Object)NumberUtils.createBigDecimal((String)i[1]));
                    }
                    return Pair.of((Object)i[0], (Object)i[1]);
                }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            }).collect(Collectors.toList());
            builder.up().withDetail("info", infoProperties);
        }
    }
}

