/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.bean;

import com.ec.primus.redis.bean.BaseRo;
import com.ec.primus.redis.trans.RedisObject;
import com.ec.primus.redis.trans.Translator;
import com.ec.primus.redis.trans.impl.TranslatorBuilder;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRedisObject<ID extends Serializable>
extends BaseRo
implements RedisObject {
    private static final long serialVersionUID = 1494528706005149030L;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private ID id;
    private Timestamp createTime = new Timestamp(System.currentTimeMillis());
    private Timestamp updateTime;
    private Translator translator = TranslatorBuilder.getDefaultTranslatorSingleton();

    public void fromMap(Map<byte[], byte[]> map) {
        this.translator.fillObject(this, map);
    }

    public Map<byte[], byte[]> toMap() {
        return this.translator.toRedisData(this);
    }

    public Logger getLog() {
        return this.log;
    }

    public ID getId() {
        return this.id;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public void setId(ID id) {
        this.id = id;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Timestamp updateTime) {
        this.updateTime = updateTime;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }
}

