/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.dao.impl;

import com.ec.primus.redis.dao.SpringJedisDAO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Repository;

@Repository(value="springJedisDAO")
public class SpringJedisDAOImpl
implements SpringJedisDAO {
    @Autowired
    private RedisTemplate<Serializable, Serializable> redisTemplate;

    @Override
    public RedisTemplate<Serializable, Serializable> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Override
    public boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public boolean hasKey(String key, String mapKey) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        return hashOperations.hasKey((Object)key, (Object)mapKey);
    }

    @Override
    public void set(String key, Object value) {
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        valueOperations.set((Object)key, value);
    }

    @Override
    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public String getString(String key) {
        return this.redisTemplate.opsForValue().get((Object)key, 0L, -1L);
    }

    @Override
    public void setList(String key, Object value) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        listOperations.leftPush((Object)key, value);
    }

    @Override
    public void setList(byte[] key, Object value) {
        ListOperations listOperations = this.redisTemplate.opsForList();
        listOperations.leftPush((Object)key, value);
    }

    @Override
    public Object getList(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    @Override
    public void setSet(String key, Set<?> value) {
        SetOperations setOperations = this.redisTemplate.opsForSet();
        setOperations.add((Object)key, new Object[]{value});
    }

    @Override
    public Object getSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public void setHash(String key, Map<String, ?> value) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        hashOperations.putAll((Object)key, value);
    }

    @Override
    public void addToHash(String key, Object hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
    }

    @Override
    public void addLeftToRightList(String key, Serializable obj) {
        this.redisTemplate.opsForList().leftPush((Object)key, (Object)obj);
    }

    @Override
    public Serializable propRightToLeftList(String key) {
        return (Serializable)this.redisTemplate.opsForList().rightPop((Object)key);
    }

    @Override
    public void delFromHash(String key, Object ... hashKeys) {
        this.redisTemplate.opsForHash().delete((Object)key, hashKeys);
    }

    @Override
    public Object getHash(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public List<?> getHashs(String key, List<String> vehicleIdList) {
        HashOperations opsForHash = this.redisTemplate.opsForHash();
        return opsForHash.multiGet((Object)key, vehicleIdList);
    }

    @Override
    public Object getHash(String key, Object hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, hashKey);
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public void clearAll() {
        this.redisTemplate.multi();
    }
}

