/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl;

import com.ec.primus.redis.annotation.RedisWriteIgnore;
import com.ec.primus.redis.bean.BaseRedisObject;
import com.ec.primus.redis.trans.BeanRegistry;
import com.ec.primus.redis.trans.ConvertorRegistry;
import com.ec.primus.redis.trans.DataItem;
import com.ec.primus.redis.trans.DataTransformer;
import com.ec.primus.redis.trans.PropertyDescriptorExtends;
import com.ec.primus.redis.trans.Translator;
import com.ec.primus.redis.trans.ValueConvertor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultTranslator
implements Translator {
    private DataTransformer dataTransformer;
    private ConvertorRegistry convertorRegistry;
    private BeanRegistry beanRegistry;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public <RO> RO toObject(Class<RO> clazz, Map<byte[], byte[]> redisData) {
        BeanRegistry beanRegistry = this.getBeanRegistry();
        RO ro = beanRegistry.newBeanInstance(clazz);
        if (MapUtils.isEmpty(redisData)) {
            return ro;
        }
        this.fillObject(ro, redisData);
        return ro;
    }

    @Override
    public void fillObject(Object ro, Map<byte[], byte[]> redisData) {
        Map<String, DataItem[]> map = this.getDataTransformer().redisData2ItemsMap(redisData);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("redis data src:");
            for (Map.Entry<String, DataItem[]> entry : map.entrySet()) {
                this.logger.trace("\t{} = {}", (Object)entry.getKey(), (Object)Arrays.toString(entry.getValue()));
            }
        }
        List<PropertyDescriptorExtends> pdes = this.beanRegistry.findProperties(ro.getClass());
        for (PropertyDescriptorExtends pde : pdes) {
            String name = pde.getName();
            DataItem[] vals = map.get(name);
            Class propertyType = pde.getPropertyType();
            Object value = this.getConvertorRegistry().findConvertor(propertyType).toValue(propertyType, name, vals);
            this.setValue(ro, pde, value);
        }
    }

    @Override
    public Map<byte[], byte[]> toRedisData(BaseRedisObject object) {
        if (object == null) {
            return Maps.newHashMapWithExpectedSize((int)1);
        }
        List<DataItem> data = this.resolveBean(object);
        return this.getDataTransformer().items2RedisData(data.toArray(new DataItem[data.size()]));
    }

    private List<DataItem> resolveBean(Object object) {
        List<PropertyDescriptorExtends> pdes = this.getBeanRegistry().findProperties(object.getClass());
        ArrayList data = Lists.newArrayList();
        for (PropertyDescriptorExtends pde : pdes) {
            Class propertyType = pde.getPropertyType();
            Object val = this.getValue(object, pde);
            if (val == Void.TYPE) continue;
            String name = pde.getName();
            ValueConvertor<Object> convertor = this.getConvertorRegistry().findConvertor(propertyType);
            DataItem[] items = convertor.toRedisData(name, val);
            data.addAll(Arrays.asList(items));
        }
        return data;
    }

    @Override
    public DataTransformer getDataTransformer() {
        return this.dataTransformer;
    }

    @Override
    public ConvertorRegistry getConvertorRegistry() {
        return this.convertorRegistry;
    }

    @Override
    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public void setDataTransformer(DataTransformer dataTransformer) {
        this.dataTransformer = dataTransformer;
    }

    public void setConvertorRegistry(ConvertorRegistry convertorRegistry) {
        this.convertorRegistry = convertorRegistry;
    }

    public void setBeanRegistry(BeanRegistry beanRegistry) {
        this.beanRegistry = beanRegistry;
    }

    private void setValue(Object pojo, PropertyDescriptorExtends pde, Object value) {
        if (value == null) {
            return;
        }
        Method writeMethod = pde.getWriteMethod();
        if (writeMethod == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("ro[type={}] prop[name={}] not found setter", pojo.getClass(), (Object)pde.getName());
            }
            return;
        }
        ReflectionUtils.invokeMethod((Method)writeMethod, (Object)pojo, (Object[])new Object[]{value});
    }

    private Object getValue(Object pojo, PropertyDescriptorExtends pde) {
        Method readMethod = pde.getReadMethod();
        if (readMethod == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("ro[type={}] prop[name={}] not found getter", pojo.getClass(), (Object)pde.getName());
            }
            return null;
        }
        RedisWriteIgnore ignore = pde.findAnnotation(RedisWriteIgnore.class);
        if (ignore == null) {
            return ReflectionUtils.invokeMethod((Method)readMethod, (Object)pojo);
        }
        if (ignore.type() == RedisWriteIgnore.IgnoreType.ALL) {
            return Void.TYPE;
        }
        Object val = ReflectionUtils.invokeMethod((Method)readMethod, (Object)pojo);
        if (ignore.type() == RedisWriteIgnore.IgnoreType.NULL && val == null) {
            return Void.TYPE;
        }
        if (ignore.type() == RedisWriteIgnore.IgnoreType.NULL_OR_EMPTY_STRING && val instanceof String && StringUtils.isBlank((CharSequence)((String)val))) {
            return Void.TYPE;
        }
        return val;
    }
}

