/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl.convertor;

import com.ec.primus.redis.trans.ConvertorRegistry;
import com.ec.primus.redis.trans.DataItem;
import com.ec.primus.redis.trans.impl.StringMap;
import com.ec.primus.redis.trans.impl.convertor.AbstractMultiValueConvertor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class StringMapComvertor
extends AbstractMultiValueConvertor<StringMap> {
    public StringMapComvertor(ConvertorRegistry convertorRegistry) {
        super(convertorRegistry);
    }

    @Override
    public DataItem[] toRedisData(String key, StringMap val) {
        if (MapUtils.isEmpty((Map)val)) {
            return new DataItem[0];
        }
        ArrayList items = Lists.newArrayList();
        for (Map.Entry<String, String> entry : val.entrySet()) {
            DataItem[] temp = this.resolveEntry(key, entry);
            items.addAll(Arrays.asList(temp));
        }
        return items.toArray(new DataItem[items.size()]);
    }

    private DataItem[] resolveEntry(String key, Map.Entry<String, String> entry) {
        String value = entry.getValue();
        if (value == null) {
            return new DataItem[0];
        }
        String propKey = entry.getKey();
        if (StringUtils.isNotBlank((CharSequence)key)) {
            propKey = key + "." + propKey;
        }
        return new DataItem[]{new DataItem(propKey, entry.getValue().getBytes())};
    }

    @Override
    public StringMap toValue(Class<StringMap> clazz, String prefix, DataItem[] redisData) {
        boolean usePrefix = StringUtils.isNotBlank((CharSequence)prefix);
        prefix = usePrefix ? prefix + "." : prefix;
        StringMap map = new StringMap();
        for (DataItem item : redisData) {
            String k = item.getKey();
            k = usePrefix ? k.replace(prefix, "") : k;
            String val = new String(item.getData());
            map.put(k, val);
        }
        return map;
    }
}

