/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.config;

import com.ec.primus.redis.config.properties.RedissonProperties;
import com.ec.primus.redis.lock.DistributedLocker;
import com.ec.primus.redis.lock.RedissonDistributedLocker;
import com.ec.primus.redis.util.RedissLockUtil;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"redisson.address"})
@ConditionalOnClass(value={Config.class, RedissonProperties.class})
@EnableConfigurationProperties(value={RedissonProperties.class})
@Configuration
public class RedissonAutoConfiguration {
    @Autowired
    private RedissonProperties redssionProperties;

    @Bean
    @ConditionalOnProperty(name={"redisson.address"})
    RedissonClient redissonSingle() {
        Config config = new Config();
        SingleServerConfig serverConfig = ((SingleServerConfig)config.useSingleServer().setAddress(this.redssionProperties.getAddress()).setTimeout(this.redssionProperties.getTimeout())).setConnectionPoolSize(this.redssionProperties.getConnectionPoolSize()).setConnectionMinimumIdleSize(this.redssionProperties.getConnectionMinimumIdleSize());
        if (StringUtils.isNotBlank((CharSequence)this.redssionProperties.getPassword())) {
            serverConfig.setPassword(this.redssionProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    @Bean
    DistributedLocker distributedLocker(RedissonClient redissonClient) {
        RedissonDistributedLocker locker = new RedissonDistributedLocker();
        locker.setRedissonClient(redissonClient);
        RedissLockUtil.setLocker(locker);
        return locker;
    }
}

