/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl;

import com.ec.primus.redis.trans.DataItem;
import com.ec.primus.redis.trans.DataTransformer;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;

public class DefaultDataTransformer
implements DataTransformer {
    @Override
    public DataItem[] redisData2Items(Map<byte[], byte[]> redisData) {
        if (MapUtils.isEmpty(redisData)) {
            return new DataItem[0];
        }
        DataItem[] items = new DataItem[redisData.size()];
        Set<Map.Entry<byte[], byte[]>> entries = redisData.entrySet();
        int index = 0;
        for (Map.Entry<byte[], byte[]> entry : entries) {
            items[index++] = new DataItem(entry);
        }
        return items;
    }

    @Override
    public Map<String, DataItem[]> redisData2ItemsMap(Map<byte[], byte[]> redisData) {
        DataItem[] items = this.redisData2Items(redisData);
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        for (DataItem item : items) {
            int index = item.getKey().indexOf(".");
            if (index >= 0) {
                String key = item.getKey().substring(0, index);
                multimap.put((Object)key, (Object)item);
                continue;
            }
            multimap.put((Object)item.getKey(), (Object)item);
        }
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            map.put(entry.getKey(), ((Collection)entry.getValue()).toArray(new DataItem[((Collection)entry.getValue()).size()]));
        }
        return map;
    }

    public static void main(String[] args) {
        System.out.println("name.id".substring(0, 4));
    }

    @Override
    public Map<byte[], byte[]> items2RedisData(DataItem[] items) {
        HashMap result = Maps.newHashMap();
        for (DataItem item : items) {
            result.put(item.getKey().getBytes(), item.getData());
        }
        return result;
    }
}

