/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl;

import com.ec.primus.redis.trans.BeanRegistry;
import com.ec.primus.redis.trans.ConvertorRegistry;
import com.ec.primus.redis.trans.PropertyDescriptorExtends;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultBeanRegistry
implements BeanRegistry {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConvertorRegistry convertorRegistry;
    private Map<Class, List<PropertyDescriptorExtends>> properties = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PropertyDescriptorExtends> findProperties(Class beanClazz) {
        List<PropertyDescriptorExtends> result = this.properties.get(beanClazz);
        if (result != null) return result;
        Class<DefaultBeanRegistry> clazz = DefaultBeanRegistry.class;
        synchronized (DefaultBeanRegistry.class) {
            this.registerObject(beanClazz);
            return this.properties.get(beanClazz);
        }
    }

    @Override
    public <RO> RO newBeanInstance(Class<RO> beanClazz) {
        try {
            return beanClazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
            return null;
        }
    }

    @Override
    public void registerObject(Class beanClazz) {
        ArrayList result = Lists.newArrayList();
        try {
            PropertyDescriptor[] pds;
            BeanInfo bi = Introspector.getBeanInfo(beanClazz, Object.class);
            for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
                if (this.getConvertorRegistry().isSupportedPropertyType(pd.getPropertyType())) {
                    result.add(new PropertyDescriptorExtends(pd, beanClazz));
                    continue;
                }
                this.logger.debug("ro[clazz={}] prop[name={},type={}] is unsupported", new Object[]{beanClazz, pd.getName(), pd.getPropertyType()});
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        this.properties.put(beanClazz, result);
    }

    @Override
    public ConvertorRegistry getConvertorRegistry() {
        return this.convertorRegistry;
    }

    public void setConvertorRegistry(ConvertorRegistry convertorRegistry) {
        this.convertorRegistry = convertorRegistry;
    }
}

