/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.swagger.helper;

import com.ec.primus.commons.exception.ExceptionType;
import com.ec.primus.swagger.annotation.ApiExceptionResponse;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

public class ExceptionResponseReader
implements OperationBuilderPlugin {
    public void apply(OperationContext context) {
        context.operationBuilder().responseMessages(this.read(context));
    }

    public boolean supports(DocumentationType documentationType) {
        return DocumentationType.SWAGGER_2 == documentationType;
    }

    protected Set<ResponseMessage> read(OperationContext context) {
        List allApiResponses = context.findAllAnnotations(ApiExceptionResponse.class);
        HashSet responseMessages = Sets.newHashSet();
        HashMap seenResponsesByCode = Maps.newHashMap();
        for (ApiExceptionResponse userExceptionResponse : allApiResponses) {
            Class<? extends ExceptionType>[] apiResponseAnnotations;
            for (Class<? extends ExceptionType> userExceptionType : apiResponseAnnotations = userExceptionResponse.value()) {
                ExceptionType[] enumConstants;
                if (!userExceptionType.isEnum()) continue;
                for (ExceptionType enumConstant : enumConstants = userExceptionType.getEnumConstants()) {
                    if (seenResponsesByCode.containsKey(enumConstant.getCode())) continue;
                    seenResponsesByCode.put(enumConstant.getCode(), userExceptionType);
                    responseMessages.add(new ResponseMessageBuilder().code(enumConstant.getCode()).message(enumConstant.getDescription()).build());
                }
            }
        }
        return responseMessages;
    }
}

