/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.swagger.config;

import com.ec.primus.commons.exception.BusinessSilentException;
import com.ec.primus.commons.utils.SpringContextUtils;
import com.ec.primus.swagger.annotation.EnableSwagger;
import com.ec.primus.swagger.helper.ExceptionResponseReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ConditionalOnBean(annotation={EnableSwagger.class})
@EnableSwagger2
@Profile(value={"!release", "!pro", "!production", "!master"})
public class SwaggerAutoConfiguration
implements ApplicationContextAware {
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${wine.application.version:'1.0.0'}")
    private String serviceVersion;
    private ApplicationContext applicationContext;

    @Bean
    Docket docket() {
        String swaggerBasePackage = null;
        String tokenHandler = null;
        new SpringContextUtils(this.applicationContext);
        List beansWithAnnotation = SpringContextUtils.findBeansByAnnotation(EnableSwagger.class);
        if (CollectionUtils.isNotEmpty((Collection)beansWithAnnotation)) {
            Object next = beansWithAnnotation.iterator().next();
            EnableSwagger annotation = next.getClass().getAnnotation(EnableSwagger.class);
            swaggerBasePackage = annotation.basePackage();
            tokenHandler = annotation.tokenHeader();
        }
        if (StringUtils.isBlank(swaggerBasePackage)) {
            throw new BusinessSilentException("Swagger base package is incorrect.");
        }
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)swaggerBasePackage)).paths(PathSelectors.any()).build().directModelSubstitute(Timestamp.class, Long.class).useDefaultResponseMessages(false);
        this.addAuthenticationHeader(tokenHandler, docket);
        return docket;
    }

    private void addAuthenticationHeader(String tokenHandler, Docket docket) {
        if (StringUtils.isNotBlank((CharSequence)tokenHandler)) {
            if (SpringContextUtils.isSpringValue((String)tokenHandler).booleanValue()) {
                tokenHandler = SpringContextUtils.getProperty((String)tokenHandler, (String)tokenHandler);
            }
            ParameterBuilder tokenPar = new ParameterBuilder();
            ArrayList<Parameter> authHeaders = new ArrayList<Parameter>(1);
            tokenPar.name(tokenHandler).description("\u8bbf\u95ee\u4ee4\u724c").modelRef((ModelReference)new ModelRef("String")).parameterType("header").required(false).build();
            authHeaders.add(tokenPar.build());
            docket.globalOperationParameters(authHeaders);
        }
    }

    @Bean
    ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Application: " + this.serviceName).version(this.serviceVersion).build();
    }

    @Bean
    ExceptionResponseReader userExceptionResponseReader() {
        return new ExceptionResponseReader();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

