package cn.com.biz.customer.controller;
import java.util.List;

import cn.com.biz.customer.entity.CustomerControlEntity;
import cn.com.biz.customer.service.CustomerControlServiceI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.web.demo.entity.test.JeecgMatterBom;
import org.jeecgframework.web.system.service.SystemService;
import org.jeecgframework.core.util.MyBeanUtils;


/**   
 * @Title: Controller
 * @Description: 客户控件信息表
 * @author onlineGenerator
 * @date 2014-08-18 15:55:00
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/customerControlController")
public class CustomerControlController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(CustomerControlController.class);

	@Autowired
	private CustomerControlServiceI customerControlService;
	@Autowired
	private SystemService systemService;


	/**
	 * 客户控件信息表列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "customerControl")
	public ModelAndView customerControl(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/customer/customerControlList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(CustomerControlEntity customerControl,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(CustomerControlEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, customerControl, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.customerControlService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除客户控件信息表
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(CustomerControlEntity customerControl, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		customerControl = systemService.getEntity(CustomerControlEntity.class, customerControl.getId());
		String message = "客户控件信息表删除成功";
		try{
			customerControlService.delete(customerControl);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "客户控件信息表删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除客户控件信息表
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "客户控件信息表删除成功";
		try{
			for(String id:ids.split(",")){
				CustomerControlEntity customerControl = systemService.getEntity(CustomerControlEntity.class, 
				Integer.parseInt(id)
				);
				customerControlService.delete(customerControl);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "客户控件信息表删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加客户控件信息表
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(CustomerControlEntity customerControl, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "客户控件信息表添加成功";
		try{
			customerControlService.save(customerControl);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "客户控件信息表添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * <li>方法名：getChildren
	 * <li>@param request HttpServletRequest
	 * <li>@param comboTree ComboTree
	 * <li>@return 物料Bom ComboTree集合
	 * <li>返回类型：List<ComboTree>
	 * <li>说明：获取物料Bom ComboTree集合
	 * <li>创建人：温俊
	 * <li>创建日期：2013-8-13
	 * <li>修改人： 
	 * <li>修改日期：
	 */
	@RequestMapping(params = "getChildren")
	@ResponseBody
	public List<ComboTree> getChildren(HttpServletRequest request, ComboTree comboTree) {
		CriteriaQuery cq = new CriteriaQuery(CustomerControlEntity.class);
		if (comboTree.getId() != null) {
			cq.eq("boxPCode", comboTree.getId());
		} else {
			cq.isNull("boxPCode");
		}
		
		cq.eq("boxCata", "B");
		cq.add();
		
		List<CustomerControlEntity> list = customerControlService.getListByCriteriaQuery(cq, false);
		List<ComboTree> comboTrees = customerControlService.myComboTree(list);
		return comboTrees;

	}
	
	/**
	 * 更新客户控件信息表
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(CustomerControlEntity customerControl, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "客户控件信息表更新成功";
		CustomerControlEntity t = customerControlService.get(CustomerControlEntity.class, customerControl.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(customerControl, t);
			customerControlService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "客户控件信息表更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 客户控件信息表新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(CustomerControlEntity customerControl, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(customerControl.getId())) {
			customerControl = customerControlService.getEntity(CustomerControlEntity.class, customerControl.getId());
			req.setAttribute("customerControlPage", customerControl);
		}
		return new ModelAndView("cn/com/biz/customer/customerControl-add");
	}
	/**
	 * 客户控件信息表编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(CustomerControlEntity customerControl, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(customerControl.getId())) {
			customerControl = customerControlService.getEntity(CustomerControlEntity.class, customerControl.getId());
			req.setAttribute("customerControlPage", customerControl);
		}
		return new ModelAndView("cn/com/biz/customer/customerControl-update");
	}
}
