package cn.com.biz.customer.controller;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import cn.com.biz.customer.dao.core.CustomerSchemeDao;
import cn.com.biz.customer.entity.CustomerControlEntity;
import cn.com.biz.customer.entity.CustomerSchemeControlEntity;
import cn.com.biz.customer.entity.CustomerSchemeEntity;
import cn.com.biz.customer.service.CustomerSchemeServiceI;


/**   
 * @Title: Controller
 * @Description: 客户信息配置项
 * @author onlineGenerator
 * @date 2014-08-18 21:41:49
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/customerSchemeController")
public class CustomerSchemeController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(CustomerSchemeController.class);

	@Autowired
	private CustomerSchemeServiceI customerSchemeService;
	@Autowired
	private SystemService systemService;
	
	@Autowired
	private CustomerSchemeDao customerSchemeDao;


	/**
	 * 客户信息配置项列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "customerScheme")
	public ModelAndView customerScheme(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/customer/customerSchemeList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(CustomerSchemeEntity customerScheme,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(CustomerSchemeEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, customerScheme, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.customerSchemeService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除客户信息配置项
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(CustomerSchemeEntity customerScheme, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		customerScheme = systemService.getEntity(CustomerSchemeEntity.class, customerScheme.getId());
		String message = "客户信息配置项删除成功";
		try{
			customerSchemeService.delete(customerScheme);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "客户信息配置项删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 客户基础信息列表页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "fun")
	public ModelAndView fun(HttpServletRequest request) {
		String customerId = request.getParameter("customerId");
		request.setAttribute("customerId", customerId);
		return new ModelAndView("cn/com/biz/customer/customerSchemeSet");
	}
	
	
	@RequestMapping(params = "upDateSchemeControl")
	@ResponseBody
	public AjaxJson upDateSchemeControl(HttpServletRequest request, ComboTree comboTree) {
		
		AjaxJson j = new AjaxJson();
		String message = "设置成功";
		try {
			String schemeControlId = request.getParameter("id");
			String strCulumn = request.getParameter("name");
			String status = request.getParameter("status");
			customerSchemeService.updateSchemeControl(schemeControlId,strCulumn,status);
		} catch (Exception e) {
			e.printStackTrace();
			message = "设置失败";
		}
		j.setMsg(message);
		return j;
	}
	
	
	
	/**
	 * 客户基础信息
	 * 
	 * @param role
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 * @return
	 */
	@RequestMapping(params = "setAuthority")
	@ResponseBody
	public List<ComboTree> setAuthority(HttpServletRequest request, ComboTree comboTree) {
		String boxCode = null;
		String customerId = request.getParameter("customerId");
		long tcs_id = Long.parseLong(customerId);
		
		if (comboTree.getId() != null) {
			boxCode = comboTree.getId();
		} 
		List<CustomerSchemeControlEntity> lstCustomerSchemeControlEntities = customerSchemeDao.getAllEntities(tcs_id, boxCode);
		
		List<ComboTree> comboTrees = customerSchemeService.myComboTree(lstCustomerSchemeControlEntities);
		return comboTrees;
	}

	
	/**
	 * 批量删除客户信息配置项
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "客户信息配置项删除成功";
		try{
			for(String id:ids.split(",")){
				CustomerSchemeEntity customerScheme = systemService.getEntity(CustomerSchemeEntity.class, 
				Integer.parseInt(id)
				);
				customerSchemeService.delete(customerScheme);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "客户信息配置项删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加客户信息配置项
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(CustomerSchemeEntity customerScheme, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "客户信息配置项添加成功";
		try{
			customerSchemeService.save(customerScheme);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "客户信息配置项添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新客户信息配置项
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(CustomerSchemeEntity customerScheme, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "客户信息配置项更新成功";
		CustomerSchemeEntity t = customerSchemeService.get(CustomerSchemeEntity.class, customerScheme.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(customerScheme, t);
			customerSchemeService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "客户信息配置项更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 客户信息配置项新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(CustomerSchemeEntity customerScheme, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(customerScheme.getId())) {
			customerScheme = customerSchemeService.getEntity(CustomerSchemeEntity.class, customerScheme.getId());
			req.setAttribute("customerSchemePage", customerScheme);
		}
		return new ModelAndView("cn/com/biz/customer/customerScheme-add");
	}
	/**
	 * 客户信息配置项编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(CustomerSchemeEntity customerScheme, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(customerScheme.getId())) {
			customerScheme = customerSchemeService.getEntity(CustomerSchemeEntity.class, customerScheme.getId());
			req.setAttribute("customerSchemePage", customerScheme);
		}
		return new ModelAndView("cn/com/biz/customer/customerScheme-update");
	}
}
