package cn.com.biz.customer.service;
import java.io.Serializable;
import java.util.List;

import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.service.CommonService;

import cn.com.biz.customer.entity.CustomerSchemeControlEntity;
import cn.com.biz.customer.entity.CustomerSchemeEntity;

public interface CustomerSchemeServiceI extends CommonService{
	
 	public <T> void delete(T entity);
 	
 	public <T> Serializable save(T entity);
 	
 	public <T> void saveOrUpdate(T entity);
 	
 	public List<ComboTree> myComboTree(List<CustomerSchemeControlEntity> list);
 	
 	/**
	 * 默认按钮-sql增强-新增操作
	 * @param id
	 * @return
	 */
 	public boolean doAddSql(CustomerSchemeEntity t);
 	/**
	 * 默认按钮-sql增强-更新操作
	 * @param id
	 * @return
	 */
 	public boolean doUpdateSql(CustomerSchemeEntity t);
 	/**
	 * 默认按钮-sql增强-删除操作
	 * @param id
	 * @return
	 */
 	public boolean doDelSql(CustomerSchemeEntity t);
 	/**
 	 * 更新经销商配置界面显示隐藏，必须和非必须
 	 * @param schemeControlId
 	 * @param strCulumn
 	 * @param status
 	 */
 	
 	public void updateSchemeControl(String schemeControlId, String strCulumn,String status);
 	
}
