package cn.com.biz.customer.service.impl;
import cn.com.biz.customer.service.CustomerControlServiceI;

import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;

import cn.com.biz.customer.dao.core.CustomerControlDao;
import cn.com.biz.customer.entity.CustomerControlEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.io.Serializable;

import jodd.util.StringUtil;

@Service("customerControlService")
@Transactional
public class CustomerControlServiceImpl extends CommonServiceImpl implements CustomerControlServiceI {
	@Autowired
	private CustomerControlDao customerControlDao;
 	public <T> void delete(T entity) {
 		super.delete(entity);
 		//执行删除操作配置的sql增强
		this.doDelSql((CustomerControlEntity)entity);
 	}
 	
 	public <T> Serializable save(T entity) {
 		Integer i;
 		CustomerControlEntity customerControlEntity = new CustomerControlEntity();
 		customerControlEntity=(CustomerControlEntity)entity;
 		
 		if(StringUtil.isNotEmpty(((CustomerControlEntity)entity).getBoxPCode()))
 		{
 		i = customerControlDao.queryCustomerControl(((CustomerControlEntity)entity).getBoxPCode());
 		}else{
 		i= customerControlDao.queryCustomerControlNull();
 		}
 		 
 		customerControlEntity.setBoxSort(i);
 		entity=(T) customerControlEntity;
 		Serializable t = super.save(entity);
 		//执行新增操作配置的sql增强
 		this.doAddSql((CustomerControlEntity)entity);
 		return t;
 	}
 	
 	public <T> void saveOrUpdate(T entity) {
 		Integer i=1;
 		//得到上级控件编码，如果上级控件编码没有修改则排序保持不变，如果上级控件编码被修改则排序修改
 		String box_p_code=customerControlDao.queryCustomerControlById(((CustomerControlEntity)entity).getId());
 		
 		if(StringUtil.equals(box_p_code, ((CustomerControlEntity)entity).getBoxPCode())||
 				StringUtil.isEmpty(box_p_code)&&StringUtil.isEmpty(((CustomerControlEntity)entity).getBoxPCode()))
 				{
 			super.saveOrUpdate(entity);
 	 		//执行更新操作配置的sql增强
 	 		this.doUpdateSql((CustomerControlEntity)entity);
 		}else{
 			CustomerControlEntity customerControlEntity = new CustomerControlEntity();
 	 		customerControlEntity=(CustomerControlEntity)entity;
 			if(StringUtil.isNotEmpty(((CustomerControlEntity)entity).getBoxPCode()))
 	 		{
 	 		i = customerControlDao.queryCustomerControl(((CustomerControlEntity)entity).getBoxPCode());
 	 		}else{
 	 		i= customerControlDao.queryCustomerControlNull();
 	 		}
 	 		customerControlEntity.setBoxSort(i);
 	 		entity=(T) customerControlEntity;
 			super.saveOrUpdate(entity);
 	 		//执行更新操作配置的sql增强
 	 		this.doUpdateSql((CustomerControlEntity)entity);
 		}
 		
 	}
 	
 	
 	public List<ComboTree> myComboTree(List<CustomerControlEntity> all){
 		List<ComboTree> trees = new ArrayList<ComboTree>();
		for (CustomerControlEntity objCustomerControlEntity : all) {
			trees.add(myComboTree(objCustomerControlEntity));
		}
		return trees;
 	}
 	
    // 构建ComboTree
 	private ComboTree myComboTree(CustomerControlEntity objCustomerControlEntity) {
 		ComboTree tree = new ComboTree();
 		tree.setId(objCustomerControlEntity.getBoxCode());
 		tree.setText(objCustomerControlEntity.getBoxName());
 		
 		CriteriaQuery cq = new CriteriaQuery(CustomerControlEntity.class);
 		cq.eq("boxPCode", objCustomerControlEntity.getBoxCode());
		cq.eq("boxCata", "B");
		cq.add();
		
		List<CustomerControlEntity> list = getListByCriteriaQuery(cq, false);
 		if (list != null && list.size() > 0) {
 			tree.setState("closed");
 			tree.setChecked(false);
 		}
 		return tree;
 	}
 	
 	
 	
 	/**
	 * 默认按钮-sql增强-新增操作
	 * @param id
	 * @return
	 */
 	public boolean doAddSql(CustomerControlEntity t){
	 	return true;
 	}
 	/**
	 * 默认按钮-sql增强-更新操作
	 * @param id
	 * @return
	 */
 	public boolean doUpdateSql(CustomerControlEntity t){
	 	return true;
 	}
 	/**
	 * 默认按钮-sql增强-删除操作
	 * @param id
	 * @return
	 */
 	public boolean doDelSql(CustomerControlEntity t){
	 	return true;
 	}
 	
 	/**
	 * 替换sql中的变量
	 * @param sql
	 * @return
	 */
 	public String replaceVal(String sql,CustomerControlEntity t){
 		sql  = sql.replace("#{id}",String.valueOf(t.getId()));
 		sql  = sql.replace("#{box_name}",String.valueOf(t.getBoxName()));
 		sql  = sql.replace("#{box_code}",String.valueOf(t.getBoxCode()));
 		sql  = sql.replace("#{box_cata}",String.valueOf(t.getBoxCata()));
 		sql  = sql.replace("#{box_p_code}",String.valueOf(t.getBoxPCode()));
 		sql  = sql.replace("#{box_sort}",String.valueOf(t.getBoxSort()));
 		sql  = sql.replace("#{box_state}",String.valueOf(t.getBoxState()));
 		sql  = sql.replace("#{box_require}",String.valueOf(t.getBoxRequire()));
 		sql  = sql.replace("#{box_type}",String.valueOf(t.getBoxType()));
 		sql  = sql.replace("#{box_default}",String.valueOf(t.getBoxDefault()));
 		sql  = sql.replace("#{box_validate}",String.valueOf(t.getBoxValidate()));
 		sql  = sql.replace("#{box_dict}",String.valueOf(t.getBoxDict()));
 		sql  = sql.replace("#{box_colnum}",String.valueOf(t.getBoxColnum()));
 		sql  = sql.replace("#{UUID}",UUID.randomUUID().toString());
 		return sql;
 	}
}