package cn.com.biz.customer.service.impl;
import cn.com.biz.customer.param.ParamStatic;
import cn.com.biz.customer.service.CustomerSchemeServiceI;

import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;

import cn.com.biz.customer.dao.core.CustomerSchemeDao;
import cn.com.biz.customer.entity.CustomerSchemeControlEntity;
import cn.com.biz.customer.entity.CustomerSchemeEntity;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.io.Serializable;

@Service("customerSchemeService")
@Transactional
public class CustomerSchemeServiceImpl extends CommonServiceImpl implements CustomerSchemeServiceI {
	@Autowired
	private CustomerSchemeDao customerSchemeDao;
 	public <T> void delete(T entity) {
 		super.delete(entity);
 		//执行删除操作配置的sql增强
		this.doDelSql((CustomerSchemeEntity)entity);
 	}
 	
 	public <T> Serializable save(T entity) {
 		Serializable t = super.save(entity);
 		//执行新增操作配置的sql增强
 		CustomerSchemeEntity objCustomerSchemeEntity = (CustomerSchemeEntity)entity;
 		this.doAddSql(objCustomerSchemeEntity);
 		long tcs_id = objCustomerSchemeEntity.getId();
 		customerSchemeDao.insertCustomerSchemeControl(tcs_id);
 		//调用存储过程
 		customerSchemeDao.creatTableBySchemeNumber(((CustomerSchemeEntity)entity).getSchemeNumber(),((CustomerSchemeEntity)entity).getSchemeUser());
 		
 		return t;
 	}
 	
 	public <T> void saveOrUpdate(T entity) {
 		super.saveOrUpdate(entity);
 		//执行更新操作配置的sql增强
 		this.doUpdateSql((CustomerSchemeEntity)entity);
 	}
 	
 	public List<ComboTree> myComboTree(List<CustomerSchemeControlEntity> list){
 		List<ComboTree> trees = new ArrayList<ComboTree>();
 		for(CustomerSchemeControlEntity objEntity : list){
 			trees.add(myComboTree(objEntity));
 		}
 		return trees;
 	}
 	
    // 构建ComboTree
  	private ComboTree myComboTree(CustomerSchemeControlEntity objCustomerSchemeControlEntity) {
  		ComboTree tree = new ComboTree();
  		tree.setId(objCustomerSchemeControlEntity.getBoxCode());
 		tree.setText(objCustomerSchemeControlEntity.getBoxName());
 		String strBoxCata=customerSchemeDao.getBoxCataByCode(objCustomerSchemeControlEntity.getBoxCode());
 		
 		String param1 = null;
 		String param2 = null;
 		String changeBoxState="onclick=changeState('"+objCustomerSchemeControlEntity.getId()+"','BOX_STATE',this.value)";
 		if(objCustomerSchemeControlEntity.getBoxState().equals(ParamStatic.SHOW)){
 			param1 = "<input type='radio' id='boxState_"+objCustomerSchemeControlEntity.getId()+"' name='boxState_"+objCustomerSchemeControlEntity.getId()+"' checked='true' "+changeBoxState+" value='Y'>显示 "
 					+"<input type='radio' id='boxState_"+objCustomerSchemeControlEntity.getId()+"' name='boxState_"+objCustomerSchemeControlEntity.getId()+"' "+changeBoxState+" value='N'>隐藏";
 		}else if(objCustomerSchemeControlEntity.getBoxState().equals(ParamStatic.HIDDEN)){
 			param1 = "<input type='radio' id='boxState_"+objCustomerSchemeControlEntity.getId()+"' name='boxState_"+objCustomerSchemeControlEntity.getId()+"' "+changeBoxState+" value='Y'>显示 "
 					+"<input type='radio' id='boxState_"+objCustomerSchemeControlEntity.getId()+"' name='boxState_"+objCustomerSchemeControlEntity.getId()+"' checked='true' "+changeBoxState+" value='N'>隐藏";
 		}
 		tree.setParam1(param1);
 		String changeRequire="onclick=changeState('"+objCustomerSchemeControlEntity.getId()+"','BOX_REQUIRE',this.value)";
 		if(strBoxCata.equals("A")){
 		if(objCustomerSchemeControlEntity.getBoxRequire().equals(ParamStatic.REQUIRED)){
 			param2 = "<input type='radio' id='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' name='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' checked='true' "+changeRequire+" value='Y'>必选 "
 					+"<input type='radio' id='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' name='boxRequire_"+objCustomerSchemeControlEntity.getId()+"'"+changeRequire+" value='N'>不必选";
 		}else if(objCustomerSchemeControlEntity.getBoxRequire().equals(ParamStatic.NOTREQUIRED)){
 			param2 = "<input type='radio' id='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' name='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' "+changeRequire+" value='Y'>必选 "
 					+"<input type='radio' id='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' name='boxRequire_"+objCustomerSchemeControlEntity.getId()+"' "+changeRequire+" value='N'  checked='true'>不必选";
 		}
 		tree.setParam2(param2);
  	   }
 		List<CustomerSchemeControlEntity> list = customerSchemeDao.getAllEntities(objCustomerSchemeControlEntity.getTcsId(), objCustomerSchemeControlEntity.getBoxCode());
 		if (list != null && list.size() > 0) {
 			tree.setState("closed");
 			tree.setChecked(false);
 		}
 		return tree;
  	}
 	
 	/**
	 * 默认按钮-sql增强-新增操作
	 * @param id
	 * @return
	 */
 	public boolean doAddSql(CustomerSchemeEntity t){
	 	return true;
 	}
 	/**
	 * 默认按钮-sql增强-更新操作
	 * @param id
	 * @return
	 */
 	public boolean doUpdateSql(CustomerSchemeEntity t){
	 	return true;
 	}
 	/**
	 * 默认按钮-sql增强-删除操作
	 * @param id
	 * @return
	 */
 	public boolean doDelSql(CustomerSchemeEntity t){
	 	return true;
 	}
 	
 	/**
	 * 替换sql中的变量
	 * @param sql
	 * @return
	 */
 	public String replaceVal(String sql,CustomerSchemeEntity t){
 		sql  = sql.replace("#{id}",String.valueOf(t.getId()));
 		sql  = sql.replace("#{scheme_name}",String.valueOf(t.getSchemeName()));
 		sql  = sql.replace("#{scheme_number}",String.valueOf(t.getSchemeNumber()));
 		sql  = sql.replace("#{scheme_status}",String.valueOf(t.getSchemeStatus()));
 		sql  = sql.replace("#{UUID}",UUID.randomUUID().toString());
 		return sql;
 	}

	public CustomerSchemeDao getCustomerSchemeDao() {
		return customerSchemeDao;
	}

	public void setCustomerSchemeDao(CustomerSchemeDao customerSchemeDao) {
		this.customerSchemeDao = customerSchemeDao;
	}

	public void updateSchemeControl(String schemeControlId, String strCulumn,
			String status) {
		customerSchemeDao.updateSchemeControl(schemeControlId, strCulumn, status);
	}
}