package cn.com.biz.main.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import cn.com.biz.main.entity.TBaseAreaEntity;
import cn.com.biz.main.help.AreaHelp;
import cn.com.biz.main.service.TBaseAreaServiceI;
import cn.com.biz.salearea.entity.TSaleAreaEntity;
import cn.com.biz.salearea.entity.TSaleBaseAreaEntity;


/**   
 * @Title: Controller
 * @Description: 地理区域
 * @author onlineGenerator
 * @date 2014-08-27 16:44:55
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/tBaseAreaController")
public class TBaseAreaController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(TBaseAreaController.class);

	@Autowired
	private TBaseAreaServiceI tBaseAreaService;
	@Autowired
	private SystemService systemService;


	/**
	 * 地理区域列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tBaseArea")
	public ModelAndView tBaseArea(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/main/baseArea/tBaseAreaList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(HttpServletRequest request,
			HttpServletResponse response, DataGrid dataGrid) {
		// CriteriaQuery cq = new CriteriaQuery(TBaseAreaEntity.class,
		// dataGrid);
		// //查询条件组装器
		// org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq,
		// tBaseArea, request.getParameterMap());
		// try{
		// //自定义追加查询条件
		// }catch (Exception e) {
		// throw new BusinessException(e.getMessage());
		// }
		// cq.add();
		// this.tBaseAreaService.getDataGridReturn(cq, true);
		// TagUtil.datagrid(response, dataGrid);
		CriteriaQuery cq = new CriteriaQuery(TBaseAreaEntity.class, dataGrid);
		this.systemService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除地理区域
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(TBaseAreaEntity tBaseArea, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tBaseArea = systemService.getEntity(TBaseAreaEntity.class, tBaseArea.getId());
		String message = "地理区域删除成功";
		try{
			tBaseAreaService.delete(tBaseArea);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "地理区域删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除地理区域
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "地理区域删除成功";
		try{
			for(String id:ids.split(",")){
				TBaseAreaEntity tBaseArea = systemService.getEntity(TBaseAreaEntity.class, 
				Integer.parseInt(id)
				);
				tBaseAreaService.delete(tBaseArea);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "地理区域删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加地理区域
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(TBaseAreaEntity tBaseArea, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "地理区域添加成功";
		try{
			if (tBaseArea.getTBaseAreaEntity().getId() == null) {
				tBaseArea.setTBaseAreaEntity(null);
				tBaseArea.setArealevel(1);
			} else {
				TBaseAreaEntity tae = systemService.getEntity(
						TBaseAreaEntity.class, tBaseArea.getTBaseAreaEntity()
								.getId());
				tBaseArea.setArealevel(tae.getArealevel() + 1);
			}
			tBaseAreaService.save(tBaseArea);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "地理区域添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新地理区域
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(TBaseAreaEntity tBaseArea, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "地理区域更新成功";
		TBaseAreaEntity t = tBaseAreaService.get(TBaseAreaEntity.class, tBaseArea.getId());
		try {
			if (tBaseArea.getTBaseAreaEntity().getId() == null) {
				tBaseArea.setTBaseAreaEntity(null);
				tBaseArea.setArealevel(1);
			} else {
				tBaseArea.setArealevel(tBaseArea.getTBaseAreaEntity()
						.getArealevel() + 1);
			}
			MyBeanUtils.copyBeanNotNull2Bean(tBaseArea, t);
			tBaseAreaService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "地理区域更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 地理区域新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(TBaseAreaEntity tBaseArea, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tBaseArea.getId())) {
			tBaseArea = tBaseAreaService.getEntity(TBaseAreaEntity.class, tBaseArea.getId());
			req.setAttribute("tBaseAreaPage", tBaseArea);
		}
		return new ModelAndView("cn/com/biz/main/baseArea/tBaseArea-add");
	}
	/**
	 * 地理区域编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(TBaseAreaEntity tBaseArea, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tBaseArea.getId())) {
			tBaseArea = tBaseAreaService.getEntity(TBaseAreaEntity.class, tBaseArea.getId());
			req.setAttribute("tBaseAreaPage", tBaseArea);
		}
		return new ModelAndView("cn/com/biz/main/baseArea/tBaseArea-update");
	}

	/**
	 * 地理区域列表，树形展示
	 * 
	 * @param request
	 * @param response
	 * @param treegrid
	 * @return
	 */
	@RequestMapping(params = "treegrid")
	@ResponseBody
	public List<TreeGrid> treegrid(TBaseAreaEntity tBaseAreaEntity,
			HttpServletRequest request, HttpServletResponse response,
			TreeGrid treegrid) {
		List<TBaseAreaEntity> baseAreaList = null;
		if (tBaseAreaEntity.getId() != null) {
			baseAreaList = systemService.findByProperty(TBaseAreaEntity.class,
					"TBaseAreaEntity.id", tBaseAreaEntity.getId());
		} else {
			CriteriaQuery cq = new CriteriaQuery(TBaseAreaEntity.class);
			cq.isNull("TBaseAreaEntity");
			cq.add();
			baseAreaList = systemService.getListByCriteriaQuery(cq, false);
		}
		List<TreeGrid> treeGrids = new ArrayList<TreeGrid>();
		TreeGridModel treeGridModel = new TreeGridModel();
		treeGridModel.setTextField("areaname");
		treeGridModel.setParentText("TBaseAreaEntity_areaname");
		treeGridModel.setParentId("TBaseAreaEntity_id");
	//	treeGridModel.setNote("areacode");
		treeGridModel.setSrc("arealevel");
		treeGridModel.setIdField("id");
		treeGridModel.setChildList("TBaseAreaEntitys");
		treeGrids = systemService.treegrid(baseAreaList, treeGridModel);
		return treeGrids;
	}

	/**
	 * 地理区域列表--comboTree
	 * 
	 */
	@RequestMapping(params = "baseAreaComboTree")
	@ResponseBody
	public List<ComboTree> baseAreaComboTree(HttpServletRequest request,
			ComboTree comboTree) {
		List<TBaseAreaEntity> baseAreaList = null;
		if (comboTree.getId() != null) {
			baseAreaList = systemService.findByProperty(TBaseAreaEntity.class,
					"TBaseAreaEntity.id", Integer.parseInt(comboTree.getId()));
		} else {
			CriteriaQuery cq = new CriteriaQuery(TBaseAreaEntity.class);
			cq.isNull("TBaseAreaEntity");
			cq.add();
			baseAreaList = systemService.getListByCriteriaQuery(cq, false);
		}
		List<ComboTree> comboTrees = new ArrayList<ComboTree>();
		ComboTreeModel comboTreeModel = new ComboTreeModel("id", "areaname",
				"TBaseAreaEntitys");
		comboTrees = systemService.ComboTree(baseAreaList, comboTreeModel,null, false);
		return comboTrees;
	}

	/**
	 * 业务区域设置地理区域的页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "baseAreaSet")
	public ModelAndView baseAreaSet(HttpServletRequest request) {
		String saleAreaId = request.getParameter("saleAreaId");
		request.setAttribute("saleAreaId", saleAreaId);
		return new ModelAndView("cn/com/biz/main/baseArea/tBaseAreaSet");
	}

	/**
	 * 业务区域设置地理区域的comboTree
	 * 
	 */
	@RequestMapping(params = "setBaseArea")
	@ResponseBody
	public List<ComboTree> setBaseArea(TSaleAreaEntity tSaleAreaEntity,
			HttpServletRequest request, ComboTree comboTree) {
		List<AreaHelp> baseAreaList = null;
		Integer pid;
		if (comboTree.getId() != null) {// 如果是找某个树节点下的
			pid = Integer.parseInt(comboTree.getId());
		} else {// 如果是找根节点下的
			pid = null;
		}
		baseAreaList = tBaseAreaService.getChildAreaByPid(pid);

		String saleAreaId = request.getParameter("saleAreaId");
		List<AreaHelp> saleBaseAreaList = tBaseAreaService
				.getAreaBysaleAreaId(Integer.parseInt(saleAreaId));
		List<ComboTree> comboTrees = new ArrayList<ComboTree>();
		ComboTreeModel coTreeModel = new ComboTreeModel("baseid", "areaname",
				"pid", "");
		ComboTreeModel inTreeModel = new ComboTreeModel("baseid", "areaname",
				"pid");// menuid为匹配字段
		comboTrees = systemService.findComboTreeByAll(baseAreaList,
				coTreeModel, saleBaseAreaList, inTreeModel);
		return comboTrees;
	}

	/**
	 * 更新业务区域的地理区域
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(params = "updateSaleBaseArea")
	@ResponseBody
	public AjaxJson updateSaleBaseArea(HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		try {
			String saleAreaId = request.getParameter("saleAreaId");
			Integer said = Integer.parseInt(saleAreaId);
			List<TSaleBaseAreaEntity> sbaList = systemService.findByProperty(
					TSaleBaseAreaEntity.class, "saleid", said);
			Set<String> baseSet = new HashSet<String>();
			for (TSaleBaseAreaEntity sbaTmp : sbaList) {
				baseSet.add(sbaTmp.getBaseid() + "");
			}
			String rolefunction = request.getParameter("baseAreas");
			String[] roleFunctions = rolefunction.split(",");
			Set<String> saveSet = new HashSet<String>();
			for (String s : roleFunctions) {
				saveSet.add(s);
			}

			for (String baseIdTmp : saveSet) {
				TSaleBaseAreaEntity saveEntity = new TSaleBaseAreaEntity();
				saveEntity.setSaleid(said);
				if (baseSet.contains(baseIdTmp)) {
					continue;
				} else {
					saveEntity.setBaseid(Integer.parseInt(baseIdTmp));
					systemService.save(saveEntity);
				}
			}
			j.setMsg("权限更新成功");
		} catch (Exception e) {
			logger.error(ExceptionUtil.getExceptionMessage(e));
			j.setMsg("权限更新失败");
		}
		return j;
	}
}
