package cn.com.biz.main.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import cn.com.biz.main.entity.TChannelEntity;
import cn.com.biz.main.entity.TChannelGroupEntity;
import cn.com.biz.main.entity.TChannelGroupSetEntity;
import cn.com.biz.main.help.ChannelHelp;
import cn.com.biz.main.service.TChannelServiceI;


/**   
 * @Title: Controller
 * @Description: 渠道主数据
 * @author onlineGenerator
 * @date 2014-08-25 10:44:58
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/tChannelController")
public class TChannelController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(TChannelController.class);

	@Autowired
	private TChannelServiceI tChannelService;
	@Autowired
	private SystemService systemService;


	/**
	 * 渠道主数据列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tChannel")
	public ModelAndView tChannel(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/main/channel/tChannelList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(TChannelEntity tChannel,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(TChannelEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, tChannel, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.tChannelService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除渠道主数据
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(TChannelEntity tChannel, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tChannel = systemService.getEntity(TChannelEntity.class, tChannel.getId());
		String message = "渠道主数据删除成功";
		try{
			systemService.delete(tChannel);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "渠道主数据删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除渠道主数据
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "渠道主数据删除成功";
		try{
			for(String id:ids.split(",")){
				TChannelEntity tChannel = systemService.getEntity(TChannelEntity.class, 
				Integer.parseInt(id)
				);
				systemService.delete(tChannel);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "渠道主数据删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加渠道主数据
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(TChannelEntity tChannel, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "渠道主数据添加成功";
		try{
			systemService.save(tChannel);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "渠道主数据添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新渠道主数据
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(TChannelEntity tChannel, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "渠道主数据更新成功";
		TChannelEntity t = systemService.get(TChannelEntity.class,
				tChannel.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tChannel, t);
			systemService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道主数据更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 渠道主数据新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(TChannelEntity tChannel, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tChannel.getId())) {
			tChannel = tChannelService.getEntity(TChannelEntity.class, tChannel.getId());
			req.setAttribute("tChannelPage", tChannel);
		}
		return new ModelAndView("cn/com/biz/main/channel/tChannel-add");
	}
	/**
	 * 渠道主数据编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(TChannelEntity tChannel, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tChannel.getId())) {
			tChannel = tChannelService.getEntity(TChannelEntity.class, tChannel.getId());
			req.setAttribute("tChannelPage", tChannel);
		}
		return new ModelAndView("cn/com/biz/main/channel/tChannel-update");
	}

	// ==========================================渠道组================================================

	/**
	 * 渠道组列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tChannelGroup")
	public ModelAndView tChannelGroup(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/main/channel/tChannelGroupList");
	}

	/**
	 * 渠道组请求数据
	 */

	@RequestMapping(params = "groupdatagrid")
	public void groupdatagrid(TChannelGroupEntity tChannelGroup,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(TChannelGroupEntity.class,
				dataGrid);
		// 查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq,
				tChannelGroup, request.getParameterMap());
		try {
			// 自定义追加查询条件
		} catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.tChannelService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除渠道组
	 * 
	 * @return
	 */
	@RequestMapping(params = "doGroupDel")
	@ResponseBody
	public AjaxJson doGroupDel(TChannelGroupEntity tChannelGroup,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tChannelGroup = systemService.getEntity(TChannelGroupEntity.class,
				tChannelGroup.getId());
		String message = "渠道组删除成功";
		try {
			systemService.delete(tChannelGroup);
			systemService.addLog(message, Globals.Log_Type_DEL,
					Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道组删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 渠道组新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goGroupAdd")
	public ModelAndView goGroupAdd(TChannelGroupEntity tChannelGroup,
			HttpServletRequest req) {
		return new ModelAndView("cn/com/biz/main/channel/tChannelGroup-add");
	}

	/**
	 * 渠道组编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goGroupUpdate")
	public ModelAndView goGroupUpdate(TChannelGroupEntity tChannelGroup,
			HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tChannelGroup.getId())) {
			tChannelGroup = systemService.getEntity(
					TChannelGroupEntity.class, tChannelGroup.getId());
			req.setAttribute("tChannelGroupPage", tChannelGroup);
		}
		return new ModelAndView("cn/com/biz/main/channel/tChannelGroup-update");
	}

	/**
	 * 添加渠道组
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doGroupAdd")
	@ResponseBody
	public AjaxJson doGroupAdd(TChannelGroupEntity tChannelGroup,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "渠道组添加成功";
		try {
			systemService.save(tChannelGroup);
			systemService.addLog(message, Globals.Log_Type_INSERT,
					Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道组添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 更新渠道组
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doGroupUpdate")
	@ResponseBody
	public AjaxJson doGroupUpdate(TChannelGroupEntity tChannelGroup,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "渠道组更新成功";
		TChannelGroupEntity t = systemService.get(
				TChannelGroupEntity.class, tChannelGroup.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tChannelGroup, t);
			systemService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE,
					Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道组更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	// ==========================================渠道组-渠道映射==============================================

	/**
	 * 渠道组和渠道映射表列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tChannelGroupSet")
	public ModelAndView tChannelGroupSet(HttpServletRequest req, String groupId) {
		req.setAttribute("groupId", groupId);
		return new ModelAndView("cn/com/biz/main/channel/tChannelGroupSetList");
	}

	/**
	 * 渠道组和渠道映射表新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goGroupSetAdd")
	public ModelAndView goGroupSetAdd(String groupId, HttpServletRequest req) {
		req.setAttribute("groupId", groupId);
		return new ModelAndView(
				"cn/com/biz/main/channel/tChannelGroupSetListUn");
	}

	/**
	 * 渠道组和渠道映射表请求数据--找组下已经有的渠道
	 */

	@RequestMapping(params = "groupSetdatagrid")
	public void groupSetdatagrid(TChannelEntity channelHelp,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		String groupId = oConvertUtils.getString(request
				.getParameter("groupId"));
		List<ChannelHelp> tChannelGroupSetList = tChannelService
				.getChannelByGroupId(Integer.parseInt(groupId));
		dataGrid.setResults(tChannelGroupSetList);
		dataGrid.setTotal(tChannelGroupSetList.size());
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 渠道组和渠道映射表请求数据--找组下还没有的渠道
	 */

	@RequestMapping(params = "unGroupSetdatagrid")
	public void unGroupSetdatagrid(ChannelHelp channelHelp,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		String groupId = oConvertUtils.getString(request
				.getParameter("groupId"));
		List<TChannelEntity> tChannelGroupSetList = tChannelService
				.getUnChannelByGroupId(Integer.parseInt(groupId));
		dataGrid.setResults(tChannelGroupSetList);
		dataGrid.setTotal(tChannelGroupSetList.size());
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除渠道组和渠道映射表
	 * 
	 * @return
	 */
	@RequestMapping(params = "doGroupSetDel")
	@ResponseBody
	public AjaxJson doGroupSetDel(TChannelGroupSetEntity tChannelGroupSet,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tChannelGroupSet = systemService.getEntity(
				TChannelGroupSetEntity.class, tChannelGroupSet.getId());
		String message = "渠道组和渠道映射表删除成功";
		try {
			systemService.delete(tChannelGroupSet);
			systemService.addLog(message, Globals.Log_Type_DEL,
					Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道组和渠道映射表删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 批量删除渠道组和渠道映射表
	 * 
	 * @return
	 */
	@RequestMapping(params = "doGroupSetBatchDel")
	@ResponseBody
	public AjaxJson doGroupSetBatchDel(String ids,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "渠道组和渠道映射表删除成功";
		try {
			for (String id : ids.split(",")) {
				TChannelGroupSetEntity tChannelGroupSet = systemService
						.getEntity(TChannelGroupSetEntity.class,
								Integer.parseInt(id));
				systemService.delete(tChannelGroupSet);
				systemService.addLog(message, Globals.Log_Type_DEL,
						Globals.Log_Leavel_INFO);
			}
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道组和渠道映射表删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 给渠道组添加渠道(支持批量)
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doGroupSetAdd")
	@ResponseBody
	public AjaxJson doGroupSetAdd(String ids, String groupId,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "渠道组添加成功";
		try {
			for (String id : ids.split(",")) {
				if (id.equals("0")) {
					continue;
				}
				TChannelGroupSetEntity tChannelGroupSet = new TChannelGroupSetEntity();
				tChannelGroupSet.setGroupid(Integer.parseInt(groupId));
				tChannelGroupSet.setChannelid(Integer.parseInt(id));
				systemService.save(tChannelGroupSet);
				systemService.addLog(message, Globals.Log_Type_INSERT,
						Globals.Log_Leavel_INFO);
			}
		} catch (Exception e) {
			e.printStackTrace();
			message = "渠道组添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
}
