package cn.com.biz.main.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import cn.com.biz.main.entity.TMaterialEntity;
import cn.com.biz.main.entity.TProductMaterialEntity;
import cn.com.biz.main.help.ProductHelp;
import cn.com.biz.main.service.TMaterialServiceI;


/**   
 * @Title: Controller
 * @Description: 物料
 * @author onlineGenerator
 * @date 2014-08-26 12:10:19
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/tMaterialController")
public class TMaterialController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(TMaterialController.class);

	@Autowired
	private TMaterialServiceI tMaterialService;
	@Autowired
	private SystemService systemService;


	/**
	 * 物料列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tMaterial")
	public ModelAndView tMaterial(HttpServletRequest request) {
		return new ModelAndView("cn/com/biz/main/material/tMaterialList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(TMaterialEntity tMaterial,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(TMaterialEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, tMaterial, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.tMaterialService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除物料
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(TMaterialEntity tMaterial, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tMaterial = systemService.getEntity(TMaterialEntity.class, tMaterial.getId());
		String message = "物料删除成功";
		try{
			tMaterialService.delete(tMaterial);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "物料删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除物料
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "物料删除成功";
		try{
			for(String id:ids.split(",")){
				TMaterialEntity tMaterial = systemService.getEntity(TMaterialEntity.class, 
				Integer.parseInt(id)
				);
				tMaterialService.delete(tMaterial);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "物料删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加物料
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(TMaterialEntity tMaterial, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "物料添加成功";
		try{
			tMaterialService.save(tMaterial);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "物料添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新物料
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(TMaterialEntity tMaterial, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "物料更新成功";
		TMaterialEntity t = tMaterialService.get(TMaterialEntity.class, tMaterial.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tMaterial, t);
			tMaterialService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "物料更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 物料新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(TMaterialEntity tMaterial, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tMaterial.getId())) {
			tMaterial = tMaterialService.getEntity(TMaterialEntity.class, tMaterial.getId());
			req.setAttribute("tMaterialPage", tMaterial);
		}
		return new ModelAndView("cn/com/biz/main/material/tMaterial-add");
	}

	/**
	 * 物料编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(TMaterialEntity tMaterial, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tMaterial.getId())) {
			tMaterial = tMaterialService.getEntity(TMaterialEntity.class, tMaterial.getId());
			req.setAttribute("tMaterialPage", tMaterial);
		}
		return new ModelAndView("cn/com/biz/main/material/tMaterial-update");
	}

	/**
	 * 某产品组下所有的物料列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tproductMaterial")
	public ModelAndView tproductMaterial(HttpServletRequest request,
			String pgroupId) {
		request.setAttribute("pgroupId", pgroupId);
		return new ModelAndView("cn/com/biz/main/material/tProductMaterialList");
	}

	/**
	 * 不属于产品组下的所有物料列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goProductMaterialAdd")
	public ModelAndView goProductMaterialAdd(HttpServletRequest request,
			String pgroupId) {
		request.setAttribute("pgroupId", pgroupId);
		return new ModelAndView(
				"cn/com/biz/main/material/tProductMaterialListUn");
	}


	/**
	 * 产品组和物料映射关系--找组下已经有的物料
	 */
	@RequestMapping(params = "productMaterialdatagrid")
	public void productMaterialdatagrid(TMaterialEntity tMaterial,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		String pgroupId = oConvertUtils.getString(request
				.getParameter("pgroupId"));
		List<ProductHelp> tProductMaterialList = tMaterialService
				.getMaterialByProductGroup(Integer.parseInt(pgroupId));
		dataGrid.setResults(tProductMaterialList);
		dataGrid.setTotal(tProductMaterialList.size());
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 产品组和物料映射关系--找组下还没有的物料
	 */
	@RequestMapping(params = "unProductMaterialdatagrid")
	public void unProductMaterialdatagrid(TMaterialEntity materialEntity,
			HttpServletRequest request, HttpServletResponse response,
			DataGrid dataGrid) {
		String pgroupId = oConvertUtils.getString(request
				.getParameter("pgroupId"));
		List<TMaterialEntity> tMaterialList = tMaterialService
				.getUnMaterialByProductGroup(Integer.parseInt(pgroupId));
		dataGrid.setResults(tMaterialList);
		dataGrid.setTotal(tMaterialList.size());
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除产品组合物料的映射关系--支持批量
	 */
	@RequestMapping(params = "doProductMaterialBatchDel")
	@ResponseBody
	public AjaxJson doProductMaterialBatchDel(String ids,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "产品组和渠道映射记录删除成功!";
		try {
			for (String id : ids.split(",")) {
				TProductMaterialEntity tProductMaterialEntity = systemService
						.getEntity(TProductMaterialEntity.class,
								Integer.parseInt(id));
				systemService.delete(tProductMaterialEntity);
				systemService.addLog(message, Globals.Log_Type_DEL,
						Globals.Log_Leavel_INFO);
			}
		} catch (NumberFormatException e) {
			e.printStackTrace();
			message = "产品组和渠道映射记录删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 给产品组添加物料(支持批量)
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doProductMaterialAdd")
	@ResponseBody
	public AjaxJson doProductMaterialAdd(String ids, String pgroupId,
			HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "物料添加成功";
		try {
			for (String id : ids.split(",")) {
				if (id.equals("0")) {
					continue;
				}
				TProductMaterialEntity t = new TProductMaterialEntity();
				t.setPid(Integer.parseInt(pgroupId));
				t.setMid(Integer.parseInt(id));
				systemService.save(t);
				systemService.addLog(message, Globals.Log_Type_INSERT,
						Globals.Log_Leavel_INFO);
			}
		} catch (Exception e) {
			e.printStackTrace();
			message = "物料添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
}
