package cn.com.biz.main.controller;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import cn.com.biz.main.entity.TProductGroupEntity;
import cn.com.biz.main.service.TProductGroupServiceI;


/**   
 * @Title: Controller
 * @Description: 产品组
 * @author onlineGenerator
 * @date 2014-08-25 10:33:29
 * @version V1.0   
 *
 */
@Controller
@RequestMapping("/tProductGroupController")
public class TProductGroupController extends BaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger.getLogger(TProductGroupController.class);

	@Autowired
	private TProductGroupServiceI tProductGroupService;
	@Autowired
	private SystemService systemService;


	/**
	 * 产品组列表 页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "tProductGroup")
	public ModelAndView tProductGroup(HttpServletRequest request) {
		return new ModelAndView(
				"cn/com/biz/main/productGroup/tProductGroupList");
	}

	/**
	 * easyui AJAX请求数据
	 * 
	 * @param request
	 * @param response
	 * @param dataGrid
	 * @param user
	 */

	@RequestMapping(params = "datagrid")
	public void datagrid(TProductGroupEntity tProductGroup,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		CriteriaQuery cq = new CriteriaQuery(TProductGroupEntity.class, dataGrid);
		//查询条件组装器
		org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil.installHql(cq, tProductGroup, request.getParameterMap());
		try{
		//自定义追加查询条件
		}catch (Exception e) {
			throw new BusinessException(e.getMessage());
		}
		cq.add();
		this.tProductGroupService.getDataGridReturn(cq, true);
		TagUtil.datagrid(response, dataGrid);
	}

	/**
	 * 删除产品组
	 * 
	 * @return
	 */
	@RequestMapping(params = "doDel")
	@ResponseBody
	public AjaxJson doDel(TProductGroupEntity tProductGroup, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		tProductGroup = systemService.getEntity(TProductGroupEntity.class, tProductGroup.getId());
		String message = "产品组删除成功";
		try{
			tProductGroupService.delete(tProductGroup);
			systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "产品组删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 批量删除产品组
	 * 
	 * @return
	 */
	 @RequestMapping(params = "doBatchDel")
	@ResponseBody
	public AjaxJson doBatchDel(String ids,HttpServletRequest request){
		AjaxJson j = new AjaxJson();
		String message = "产品组删除成功";
		try{
			for(String id:ids.split(",")){
				TProductGroupEntity tProductGroup = systemService.getEntity(TProductGroupEntity.class, 
				Integer.parseInt(id)
				);
				tProductGroupService.delete(tProductGroup);
				systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
			}
		}catch(Exception e){
			e.printStackTrace();
			message = "产品组删除失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}


	/**
	 * 添加产品组
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doAdd")
	@ResponseBody
	public AjaxJson doAdd(TProductGroupEntity tProductGroup, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "产品组添加成功";
		try{
			tProductGroupService.save(tProductGroup);
			systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
		}catch(Exception e){
			e.printStackTrace();
			message = "产品组添加失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	
	/**
	 * 更新产品组
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(params = "doUpdate")
	@ResponseBody
	public AjaxJson doUpdate(TProductGroupEntity tProductGroup, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		String message = "产品组更新成功";
		TProductGroupEntity t = tProductGroupService.get(TProductGroupEntity.class, tProductGroup.getId());
		try {
			MyBeanUtils.copyBeanNotNull2Bean(tProductGroup, t);
			tProductGroupService.saveOrUpdate(t);
			systemService.addLog(message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
		} catch (Exception e) {
			e.printStackTrace();
			message = "产品组更新失败";
			throw new BusinessException(e.getMessage());
		}
		j.setMsg(message);
		return j;
	}
	

	/**
	 * 产品组新增页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goAdd")
	public ModelAndView goAdd(TProductGroupEntity tProductGroup, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tProductGroup.getId())) {
			tProductGroup = tProductGroupService.getEntity(TProductGroupEntity.class, tProductGroup.getId());
			req.setAttribute("tProductGroupPage", tProductGroup);
		}
		return new ModelAndView(
				"cn/com/biz/main/productGroup/tProductGroup-add");
	}
	/**
	 * 产品组编辑页面跳转
	 * 
	 * @return
	 */
	@RequestMapping(params = "goUpdate")
	public ModelAndView goUpdate(TProductGroupEntity tProductGroup, HttpServletRequest req) {
		if (StringUtil.isNotEmpty(tProductGroup.getId())) {
			tProductGroup = tProductGroupService.getEntity(TProductGroupEntity.class, tProductGroup.getId());
			req.setAttribute("tProductGroupPage", tProductGroup);
		}
		return new ModelAndView(
				"cn/com/biz/main/productGroup/tProductGroup-update");
	}
}
